'-----------------------------------------------------------------------------
'   $RCSfile: dwgcontrol.bas,v $
'   $Revision: 1.7 $
'   $Date: 2000/03/16 14:42:30 $
'-----------------------------------------------------------------------------
'
' DWG Translator Basic Extention - program
'  -refer to dwgBasic.readme for brief description of each method or property

Sub Main

' Map orhpan cells to anonymous blocks under name *o:
MbeBlockNameTable.addExportEntry "*o", ""
' Map fonts using true types if environment variable USE_TTF=1; otherwise
' map them using shape file names.
Dim envVal as String
if Val(MbeGetConfigVar ("USE_TTFF")) = 1 then
    MbeFontNameTable.addImportExportEntryFromFile "ttfont.tbl"
else
    MbeFontNameTable.addImportExportEntryFromFile "dwgfont.tbl"
end if
' Map hatch to pattern cells
MbeHatchTable.addImportEntryFromFile "dwghatch.tbl"
' Map weights to weights
MbeWeightWeightTable.addImportEntryFromFile "dwgwtwt1.tbl", "MS_DWGTABLES"
MbeWeightWeightTable.addExportEntryFromFile "dwgwtwt2.tbl", "MS_DWGTABLES"

MbeDWGImportSettings.polylineWidthAs = MBE_Linestyle 	' MBE_Shape, 
                                                        ' MBE_Linestyle, 
                                                        ' MBE_Weight,
                                                        ' MBE_None
MbeDWGImportSettings.ignoreEmptyLayers = MBE_Off     	' MBE_On, MBE_Off
MbeDWGImportSettings.strokeSplines = MBE_Off            ' MBE_On, MBE_Off
MbeDWGImportSettings.dimCreate = MBE_CREATEDIMCELL      ' MBE_CREATEDIMCELL,
                                                        ' MBE_CREATEDIMCOMBO,
                                                        ' MBE_CREATEDIMONLY
MbeDWGImportSettings.justifyText = MBE_On	    	' MBE_On, MBE_Off
MbeDWGImportSettings.convertACIS = MBE_Default          ' MBE_Ignore, MBE_Wireframe, MBE_Default
MbeDWGImportSettings.defaultFont = 3			' any valid MS font number
MbeDWGImportSettings.createFileCell = MBE_Off		'MBE_On, MBE_Off
MbeDWGImportSettings.ignoreXData = MBE_Off		'MBE_On, MBE_Off
MbeDWGImportSettings.saveDGNSettings = MBE_On            'MBE_On, MBE_Off

MbeDWGExportSettings.ltScale = 1.0		    	' any value > 0
MbeDWGExportSettings.DXFPrecision = 6		    	' any positive int 
MbeDWGExportSettings.refNameInLayer = MBE_ON	    	' MBE_On, MBE_Off
MbeDWGExportSettings.reverseTagOrder = MBE_Off          ' MBE_On, MBE_Off
MbeDWGExportSettings.createDim = MBE_CREATEDIMONLY      ' MBE_CREATEDIMCELL,
                                                        ' MBE_CREATEDIMONLY
                                                        ' MBE_DROPDIM2COMP
MbeDWGExportSettings.convertNormalCell = MBE_Block_Normal   ' MBE_Block_Normal,
                                                            ' MBE_Block_Anonymous
                                                            ' MBE_Block_Unique
MbeDWGExportSettings.ignoreBlankText = MBE_Off		' MBE_On, MBE_Off
MbeDWGExportSettings.meshChordTolerance  = 0.5		' any value >= 0
MbeDWGExportSettings.meshNormTolerance   = 10.0		' any value >= 0
MbeDWGExportSettings.meshSizeTolerance   = 0.0		' any value >= 0
MbeDWGExportSettings.splineSegs		 = 10		' any positive int
MbeDWGExportSettings.ACISVersion = MBE_ACIS300		'MBE_ACIS105
                                                        'MBE_ACIS106
                                                        'MBE_ACIS107
                                                        'MBE_ACIS108
                                                        'MBE_ACIS200
                                                        'MBE_ACIS201
                                                        'MBE_ACIS300
                                                        'MBE_ACIS400
MbeDWGExportSettings.levelsTurnedOff = MBE_LevelsOff_Ignore 'MBE_LevelsOff_Freeze
                                                            'MBE_LevelsOff_Thaw
MbeDWGExportSettings.defaultFont = "txt.shx"		    ' any valid ACAD shape file name
MbeDWGExportSettings.planarLineString = MBE_Polyline_2D     ' MBE_Polyline_3D, 
                                                            ' MBE_Polyline_2D
MbeDWGExportSettings.bsplineCurve = MBE_BCURVE_Parameters   ' MBE_BCURVE_Parameters,
                                                            ' MBE_BCURVE_FitPoints
                                                            ' MBE_BCURVE_Polyline
MbeDWGExportSettings.dimensionStyle = "MSADIM"
MbeDWGExportSettings.constructionClassLayer = "CONSTRUCTION_CLASS"
MbeDWGExportSettings.patternClassLayer = "PATTERN_CLASS"
' If environment variable COPY_RASTER_FILES=1, then copy raster attachments
' to the exported DWG directory:
if Val(MbeGetConfigVar ("COPY_RASTER_FILES")) = 1 then
    MbeDWGExportSettings.copyRasterFileTo = "*"
end if
MbeDWGExportSettings.convertRotatedViewToUcs = MBE_Off       ' MBE_On, MBE_Off
MbeDWGExportSettings.convertSpecialCharacters = MBE_On	     ' MBE_On, MBE_Off

'--------------------------------------------------------------------------------
'   Following section is reserved for DWG applications to read/write GUI data.
'   Thus this file is required to be on a local directory.  This section is filled
'   automatically by the GUI.  Thus any manual editing here may be overridden by
'   the DWG application's dialog boxes.
'--------------------------------------------------------------------------------
'Begin Auto Edit
MbeLevelTable.addImportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwglevel.tbl", "MASTERFILE"
MbeWeightColor.addImportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgwtco.tbl"
MbeLineStyle.addImportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgline.tbl"
MbeColorTable.addImportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgcolor.tbl"
MbeCharTable.addImportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgchar.tbl"
MbeDWGImportSettings.xRefNestDepth = 10
Dim point0 as MbePoint
	point0.x = 0#
	point0.y = 0#
	point0.z = 0#
stat = MbeDWGImportSettings.setOrigin (point0)
MbeDWGImportSettings.shiftGlobalOrigin = MBE_Off
MbeDWGImportSettings.importFrozenLayers = MBE_On
MbeDWGImportSettings.mapWeightColor = MBE_Off
MbeDWGImportSettings.displayElement = MBE_On
MbeDWGImportSettings.compressFractions = MBE_Off
MbeDWGImportSettings.mapCharacters = MBE_Off
MbeDWGImportSettings.useLineStyles = MBE_On
MbeDWGImportSettings.resolveXRef = MBE_XRefMissing
MbeDWGImportSettings.unitsMode = MBE_Master
MbeDWGImportSettings.cellMode = MBE_Library
MbeDWGImportSettings.colorMode = MBE_UserMapping
MbeDWGImportSettings.convertAttributes = MBE_Tags
MbeLevelTable.addExportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwglevel.tbl", "MASTERFILE"
MbeWeightColor.addExportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgwtco.tbl"
MbeLineStyle.addExportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgline.tbl"
MbeColorTable.addExportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgcolor.tbl"
MbeCharTable.addExportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgchar.tbl"
MbeWeightWidth.addExportEntryFromFile "C:\Bentley\Home\prefs\dwgdata\dwgwtwd.tbl"
MbeDWGExportSettings.refSourceView = 1
MbeDWGExportSettings.masterSourceView = 0
MbeDWGExportSettings.numberOfColors = 256
MbeDWGExportSettings.seedDWGFile = "c:\Bentley\apz_tab.dwg"
MbeDWGExportSettings.overrideLevelNames = MBE_Off
MbeDWGExportSettings.expandFractions = MBE_On
MbeDWGExportSettings.useColorMapping = MBE_On
MbeDWGExportSettings.useCharMapping = MBE_Off
MbeDWGExportSettings.convertWeight = MBE_WeightAs_Ignore
MbeDWGExportSettings.defaultRefMode = MBE_MergeRef
MbeDWGExportSettings.defaultClippedRefMode = MBE_MergeRef
MbeDWGExportSettings.defaultSelfRefMode = MBE_MergeRef
MbeDWGExportSettings.resolveRefAttachments = MBE_XRefMissing
MbeDWGExportSettings.unitsMode = MBE_Master
MbeDWGExportSettings.dwgVersion = MBE_DWGVER_15
MbeDWGExportSettings.convertShapes = MBE_Shape_As_Polyline
MbeDWGExportSettings.convertSmallFilledShapes = MBE_Shape_As_Polyline
MbeDWGExportSettings.convertSmallShapes = MBE_Shape_As_Polyline
MbeDWGExportSettings.convertWideLineCode = MBE_LStyleOpt_PolyLine
MbeDWGExportSettings.convertComplexLStyle = MBE_LStyleOpt_Components
MbeDWGExportSettings.dxfOutOption = MBE_DXFFile_Complete
'End Auto Edit
'Begin User Override
'--------------------------------------------------------------------------------
'   Below example shows a way of centralized control of translation.  All
'   standard settings are placed in dwgstandard.bas which is, by default, 
'   located on $(_USTN_SITE)tables\dwg.  This file can be shared over the
'   network such that GUI settings on each terminal always get overridden
'   by the the settings in that file.
'--------------------------------------------------------------------------------
'MbeAddDwgBasicFile ("dwgstandard.bas")
'End User Override
end sub
