/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JTree;
import com.sun.java.swing.event.CellEditorListener;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.table.TableCellEditor;
import com.sun.java.swing.tree.TreeCellEditor;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;

public class DefaultCellEditor
implements TableCellEditor,
TreeCellEditor,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent;
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 1;
    static /* synthetic */ Class class$com$sun$java$swing$event$CellEditorListener;

    public DefaultCellEditor(JTextField jTextField) {
        this.editorComponent = jTextField;
        this.clickCountToStart = 2;
        this.delegate = new 1(this);
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
    }

    public DefaultCellEditor(JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new 2(this);
        ((JCheckBox)this.editorComponent).addActionListener(this.delegate);
    }

    public DefaultCellEditor(JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        this.delegate = new 3(this);
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() < this.clickCountToStart) {
            return false;
        }
        return this.delegate.isCellEditable(eventObject);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = true;
        if (this.isCellEditable(eventObject) && (eventObject == null || ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart)) {
            bl = this.delegate.startCellEditing(eventObject);
        }
        return bl;
    }

    public boolean stopCellEditing() {
        boolean bl = this.delegate.stopCellEditing();
        if (bl) {
            this.fireEditingStopped();
        }
        return bl;
    }

    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$com$sun$java$swing$event$CellEditorListener != null ? class$com$sun$java$swing$event$CellEditorListener : (class$com$sun$java$swing$event$CellEditorListener = DefaultCellEditor.class$("com.sun.java.swing.event.CellEditorListener")), cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$CellEditorListener != null ? class$com$sun$java$swing$event$CellEditorListener : (class$com$sun$java$swing$event$CellEditorListener = DefaultCellEditor.class$("com.sun.java.swing.event.CellEditorListener")), cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$CellEditorListener != null ? class$com$sun$java$swing$event$CellEditorListener : DefaultCellEditor.class$("com.sun.java.swing.event.CellEditorListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(this.changeEvent);
            }
            n -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$CellEditorListener != null ? class$com$sun$java$swing$event$CellEditorListener : DefaultCellEditor.class$("com.sun.java.swing.event.CellEditorListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(this.changeEvent);
            }
            n -= 2;
        }
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends EditorDelegate {
        public void setValue(Object object) {
            super.setValue(object);
            if (object != null) {
                ((JTextField)DefaultCellEditor.this.editorComponent).setText(object.toString());
                return;
            }
            ((JTextField)DefaultCellEditor.this.editorComponent).setText("");
        }

        public Object getCellEditorValue() {
            return ((JTextField)DefaultCellEditor.this.editorComponent).getText();
        }

        public boolean startCellEditing(EventObject eventObject) {
            if (eventObject == null) {
                DefaultCellEditor.this.editorComponent.requestFocus();
            }
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        /* synthetic */ 1(DefaultCellEditor defaultCellEditor2) {
        }
    }

    private final class 2
    extends EditorDelegate {
        public void setValue(Object object) {
            super.setValue(object);
            if (object instanceof Boolean) {
                ((JCheckBox)DefaultCellEditor.this.editorComponent).setSelected((Boolean)object);
                return;
            }
            if (object instanceof String) {
                Boolean bl = new Boolean((String)object);
                ((JCheckBox)DefaultCellEditor.this.editorComponent).setSelected(bl);
                return;
            }
            ((JCheckBox)DefaultCellEditor.this.editorComponent).setSelected(false);
        }

        public Object getCellEditorValue() {
            return new Boolean(((JCheckBox)DefaultCellEditor.this.editorComponent).isSelected());
        }

        public boolean startCellEditing(EventObject eventObject) {
            return eventObject instanceof AWTEvent;
        }

        public boolean stopCellEditing() {
            return true;
        }

        /* synthetic */ 2(DefaultCellEditor defaultCellEditor2) {
        }
    }

    private final class 3
    extends EditorDelegate {
        public void setValue(Object object) {
            super.setValue(object);
            ((JComboBox)DefaultCellEditor.this.editorComponent).setSelectedItem(object);
        }

        public Object getCellEditorValue() {
            return ((JComboBox)DefaultCellEditor.this.editorComponent).getSelectedItem();
        }

        public boolean startCellEditing(EventObject eventObject) {
            return eventObject instanceof AWTEvent;
        }

        public boolean stopCellEditing() {
            return true;
        }

        /* synthetic */ 3(DefaultCellEditor defaultCellEditor2) {
        }
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultCellEditor.this.fireEditingStopped();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DefaultCellEditor.this.fireEditingStopped();
        }

        EditorDelegate() {
            DefaultCellEditor.this = DefaultCellEditor.this;
        }
    }
}

