/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDesktopPane;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.OptionPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class JOptionPane
extends JComponent {
    public static final Object UNINITIALIZED_VALUE = "uninitializedValue";
    public static final int DEFAULT_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final String ICON_PROPERTY = "icon";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String VALUE_PROPERTY = "value";
    public static final String OPTIONS_PROPERTY = "options";
    public static final String INITIAL_VALUE_PROPERTY = "initialValue";
    public static final String MESSAGE_TYPE_PROPERTY = "messageType";
    public static final String OPTION_TYPE_PROPERTY = "optionType";
    public static final String SELECTION_VALUES_PROPERTY = "selectionValues";
    public static final String INITIAL_SELECTION_VALUE_PROPERTY = "initialSelectionValue";
    public static final String INPUT_VALUE_PROPERTY = "inputValue";
    public static final String WANTS_INPUT_PROPERTY = "wantsInput";
    protected transient Icon icon;
    protected transient Object message;
    protected transient Object[] options;
    protected transient Object initialValue;
    protected int messageType;
    protected int optionType;
    protected transient Object value;
    protected transient Object[] selectionValues;
    protected transient Object inputValue;
    protected transient Object initialSelectionValue;
    protected boolean wantsInput;
    private static final Object sharedFrameKey = class$com$sun$java$swing$JOptionPane != null ? class$com$sun$java$swing$JOptionPane : (class$com$sun$java$swing$JOptionPane = JComponent.class$("com.sun.java.swing.JOptionPane"));
    static /* synthetic */ Class class$com$sun$java$swing$JOptionPane;

    public static String showInputDialog(Object object) {
        return JOptionPane.showInputDialog(null, object);
    }

    public static String showInputDialog(Component component, Object object) {
        return JOptionPane.showInputDialog(component, object, "Input", 3);
    }

    public static String showInputDialog(Component component, Object object, String string, int n) {
        return (String)JOptionPane.showInputDialog(component, object, string, n, null, null, null);
    }

    public static Object showInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n, 2, icon, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jOptionPane.selectInitialValue();
        jDialog.show();
        Object object3 = jOptionPane.getInputValue();
        if (object3 == "uninitializedValue") {
            return null;
        }
        return object3;
    }

    public static void showMessageDialog(Component component, Object object) {
        JOptionPane.showMessageDialog(component, object, "Message", 1);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n, null);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n, Icon icon) {
        JOptionPane.showOptionDialog(component, object, string, -1, n, icon, null, null);
    }

    public static int showConfirmDialog(Component component, Object object) {
        return JOptionPane.showConfirmDialog(component, object, "Select an Option", 1);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n) {
        return JOptionPane.showConfirmDialog(component, object, string, n, 3);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2) {
        return JOptionPane.showConfirmDialog(component, object, string, n, n2, null);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        return JOptionPane.showOptionDialog(component, object, string, n, n2, icon, null, null);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        jOptionPane.setInitialValue(object2);
        JDialog jDialog = jOptionPane.createDialog(component, string);
        jOptionPane.selectInitialValue();
        jDialog.show();
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            if (objectArray[n3].equals(object3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public JDialog createDialog(Component component, String string) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        JDialog jDialog = SwingUtilities.getRecycledModalDialog(frame, string);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.addWindowListener(new 1());
        this.addPropertyChangeListener(new 2(jDialog, this));
        return jDialog;
    }

    public static void showInternalMessageDialog(Component component, Object object) {
        JOptionPane.showInternalMessageDialog(component, object, "Message", 1);
    }

    public static void showInternalMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showInternalMessageDialog(component, object, string, n, null);
    }

    public static void showInternalMessageDialog(Component component, Object object, String string, int n, Icon icon) {
        JOptionPane.showInternalOptionDialog(component, object, string, -1, n, icon, null, null);
    }

    public static int showInternalConfirmDialog(Component component, Object object) {
        return JOptionPane.showInternalConfirmDialog(component, object, "Select an Option", 1);
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n) {
        return JOptionPane.showInternalConfirmDialog(component, object, string, n, 3);
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n, int n2) {
        return JOptionPane.showInternalConfirmDialog(component, object, string, n, n2, null);
    }

    public static int showInternalConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        return JOptionPane.showInternalOptionDialog(component, object, string, n, n2, icon, null, null);
    }

    public static int showInternalOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
        jOptionPane.setInitialValue(object2);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        jOptionPane.selectInitialValue();
        jInternalFrame.startModal();
        Object object3 = jOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            if (objectArray[n3].equals(object3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static String showInternalInputDialog(Component component, Object object) {
        return JOptionPane.showInternalInputDialog(component, object, "Input", 3);
    }

    public static String showInternalInputDialog(Component component, Object object, String string, int n) {
        return (String)JOptionPane.showInternalInputDialog(component, object, string, n, null, null, null);
    }

    public static Object showInternalInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        JOptionPane jOptionPane = new JOptionPane(object, n, 2, icon, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(objectArray);
        jOptionPane.setInitialSelectionValue(object2);
        JInternalFrame jInternalFrame = jOptionPane.createInternalFrame(component, string);
        jOptionPane.selectInitialValue();
        jInternalFrame.startModal();
        Object object3 = jOptionPane.getInputValue();
        if (object3 == "uninitializedValue") {
            return null;
        }
        return (String)object3;
    }

    public JInternalFrame createInternalFrame(Component component, String string) {
        Container container = JOptionPane.getDesktopPaneForComponent(component);
        if (container == null && (component == null || (container = component.getParent()) == null)) {
            throw new RuntimeException("JOptionPane: parentComponent does not have a valid parent");
        }
        JInternalFrame jInternalFrame = new JInternalFrame(string, false, false, false, false);
        this.addPropertyChangeListener(new 3(jInternalFrame, this));
        jInternalFrame.getContentPane().add((Component)this, "Center");
        if (container instanceof JDesktopPane) {
            container.add((Component)jInternalFrame, JLayeredPane.MODAL_LAYER);
        } else {
            container.add((Component)jInternalFrame, "Center");
        }
        Dimension dimension = jInternalFrame.getPreferredSize();
        Dimension dimension2 = container.getSize();
        jInternalFrame.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        container.validate();
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        return jInternalFrame;
    }

    public static Frame getFrameForComponent(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return JOptionPane.getFrameForComponent(component.getParent());
    }

    public static JDesktopPane getDesktopPaneForComponent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JDesktopPane) {
            return (JDesktopPane)component;
        }
        return JOptionPane.getDesktopPaneForComponent(component.getParent());
    }

    public static void setRootFrame(Frame frame) {
        if (frame != null) {
            SwingUtilities.appContextPut(sharedFrameKey, frame);
            return;
        }
        SwingUtilities.appContextRemove(sharedFrameKey);
    }

    public static Frame getRootFrame() {
        Frame frame = (Frame)SwingUtilities.appContextGet(sharedFrameKey);
        if (frame == null) {
            frame = SwingUtilities.getSharedOwnerFrame();
            SwingUtilities.appContextPut(sharedFrameKey, frame);
        }
        return frame;
    }

    public JOptionPane() {
        this("JOptionPane message");
    }

    public JOptionPane(Object object) {
        this(object, -1);
    }

    public JOptionPane(Object object, int n) {
        this(object, n, -1);
    }

    public JOptionPane(Object object, int n, int n2) {
        this(object, n, n2, null);
    }

    public JOptionPane(Object object, int n, int n2, Icon icon) {
        this(object, n, n2, icon, null);
    }

    public JOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray) {
        this(object, n, n2, icon, objectArray, null);
    }

    public JOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        this.message = object;
        this.options = objectArray;
        this.initialValue = object2;
        this.icon = icon;
        this.setMessageType(n);
        this.setOptionType(n2);
        this.value = "uninitializedValue";
        this.inputValue = "uninitializedValue";
        this.updateUI();
    }

    public void setUI(OptionPaneUI optionPaneUI) {
        if ((OptionPaneUI)this.ui != optionPaneUI) {
            super.setUI(optionPaneUI);
            this.invalidate();
        }
    }

    public OptionPaneUI getUI() {
        return (OptionPaneUI)this.ui;
    }

    public void updateUI() {
        this.setUI((OptionPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "OptionPaneUI";
    }

    public void setMessage(Object object) {
        Object object2 = this.message;
        this.message = object;
        this.firePropertyChange(MESSAGE_PROPERTY, object2, this.message);
    }

    public Object getMessage() {
        return this.message;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.icon;
        this.icon = icon;
        this.firePropertyChange(ICON_PROPERTY, icon2, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setValue(Object object) {
        Object object2 = this.value;
        this.value = object;
        this.firePropertyChange(VALUE_PROPERTY, object2, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setOptions(Object[] objectArray) {
        Object[] objectArray2 = this.options;
        this.options = objectArray;
        this.firePropertyChange(OPTIONS_PROPERTY, objectArray2, this.options);
    }

    public Object[] getOptions() {
        if (this.options != null) {
            int n = this.options.length;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.options, 0, objectArray, 0, n);
            return objectArray;
        }
        return this.options;
    }

    public void setInitialValue(Object object) {
        Object object2 = this.initialValue;
        this.initialValue = object;
        this.firePropertyChange(INITIAL_VALUE_PROPERTY, object2, this.initialValue);
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setMessageType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != -1) {
            throw new RuntimeException("JOptionPane: type must be one of JOptionPane.ERROR_MESSAGE, JOptionPane.INFORMATION_MESSAGE, JOptionPane.WARNING_MESSAGE, JOptionPane.QUESTION_MESSAGE or JOptionPane.PLAIN_MESSAGE");
        }
        int n2 = this.messageType;
        this.messageType = n;
        this.firePropertyChange(MESSAGE_TYPE_PROPERTY, n2, this.messageType);
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setOptionType(int n) {
        if (n != -1 && n != 0 && n != 1 && n != 2) {
            throw new RuntimeException("JOptionPane: option type must be one of JOptionPane.DEFAULT_OPTION, JOptionPane.YES_NO_OPTION, JOptionPane.YES_NO_CANCEL_OPTION or JOptionPane.OK_CANCEL_OPTION");
        }
        int n2 = this.optionType;
        this.optionType = n;
        this.firePropertyChange(OPTION_TYPE_PROPERTY, n2, this.optionType);
    }

    public int getOptionType() {
        return this.optionType;
    }

    public void setSelectionValues(Object[] objectArray) {
        Object[] objectArray2 = this.selectionValues;
        this.selectionValues = objectArray;
        this.firePropertyChange(SELECTION_VALUES_PROPERTY, objectArray2, objectArray);
        if (this.selectionValues != null) {
            this.setWantsInput(true);
        }
    }

    public Object[] getSelectionValues() {
        return this.selectionValues;
    }

    public void setInitialSelectionValue(Object object) {
        Object object2 = this.initialSelectionValue;
        this.initialSelectionValue = object;
        this.firePropertyChange(INITIAL_SELECTION_VALUE_PROPERTY, object2, object);
    }

    public Object getInitialSelectionValue() {
        return this.initialSelectionValue;
    }

    public void setInputValue(Object object) {
        Object object2 = this.inputValue;
        this.inputValue = object;
        this.firePropertyChange(INPUT_VALUE_PROPERTY, object2, object);
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public int getMaxCharactersPerLineCount() {
        return Integer.MAX_VALUE;
    }

    public void setWantsInput(boolean bl) {
        boolean bl2 = this.wantsInput;
        this.wantsInput = bl;
        this.firePropertyChange(WANTS_INPUT_PROPERTY, bl2, bl);
    }

    public boolean getWantsInput() {
        return this.wantsInput;
    }

    public void selectInitialValue() {
        OptionPaneUI optionPaneUI = this.getUI();
        if (optionPaneUI != null) {
            optionPaneUI.selectInitialValue();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        int n2;
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.icon != null && this.icon instanceof Serializable) {
            vector.addElement(ICON_PROPERTY);
            vector.addElement(this.icon);
        }
        if (this.message != null && this.message instanceof Serializable) {
            vector.addElement(MESSAGE_PROPERTY);
            vector.addElement(this.message);
        }
        if (this.options != null) {
            Vector<Object> vector2 = new Vector<Object>();
            n2 = 0;
            n = this.options.length;
            while (n2 < n) {
                if (this.options[n2] instanceof Serializable) {
                    vector2.addElement(this.options[n2]);
                }
                ++n2;
            }
            if (vector2.size() > 0) {
                int n3 = vector2.size();
                Object[] objectArray = new Object[n3];
                vector2.copyInto(objectArray);
                vector.addElement(OPTIONS_PROPERTY);
                vector.addElement(objectArray);
            }
        }
        if (this.initialValue != null && this.initialValue instanceof Serializable) {
            vector.addElement(INITIAL_VALUE_PROPERTY);
            vector.addElement(this.initialValue);
        }
        if (this.value != null && this.value instanceof Serializable) {
            vector.addElement(VALUE_PROPERTY);
            vector.addElement(this.value);
        }
        if (this.selectionValues != null) {
            boolean bl = true;
            n2 = 0;
            n = this.selectionValues.length;
            while (n2 < n) {
                if (this.selectionValues[n2] != null && !(this.selectionValues[n2] instanceof Serializable)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                vector.addElement(SELECTION_VALUES_PROPERTY);
                vector.addElement(this.selectionValues);
            }
        }
        if (this.inputValue != null && this.inputValue instanceof Serializable) {
            vector.addElement(INPUT_VALUE_PROPERTY);
            vector.addElement(this.inputValue);
        }
        if (this.initialSelectionValue != null && this.initialSelectionValue instanceof Serializable) {
            vector.addElement(INITIAL_SELECTION_VALUE_PROPERTY);
            vector.addElement(this.initialSelectionValue);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals(ICON_PROPERTY)) {
            this.icon = (Icon)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(MESSAGE_PROPERTY)) {
            this.message = vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(OPTIONS_PROPERTY)) {
            this.options = (Object[])vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(INITIAL_VALUE_PROPERTY)) {
            this.initialValue = vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(VALUE_PROPERTY)) {
            this.value = vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_VALUES_PROPERTY)) {
            this.selectionValues = (Object[])vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(INPUT_VALUE_PROPERTY)) {
            this.inputValue = vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(INITIAL_SELECTION_VALUE_PROPERTY)) {
            this.initialSelectionValue = vector.elementAt(++n);
            ++n;
        }
    }

    private final class 1
    extends WindowAdapter {
        boolean gotFocus = false;

        public void windowClosing(WindowEvent windowEvent) {
            JOptionPane.this.setValue(null);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (!this.gotFocus) {
                JOptionPane.this.selectInitialValue();
                this.gotFocus = true;
            }
        }

        /* synthetic */ 1() {
        }
    }

    private static final class 2
    implements PropertyChangeListener {
        private final /* synthetic */ JOptionPane this$0;
        private final /* synthetic */ JDialog val$dialog;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.val$dialog.isVisible() && propertyChangeEvent.getSource() == this.this$0 && (propertyChangeEvent.getPropertyName().equals(JOptionPane.VALUE_PROPERTY) || propertyChangeEvent.getPropertyName().equals(JOptionPane.INPUT_VALUE_PROPERTY))) {
                ((Component)this.val$dialog).setVisible(false);
                SwingUtilities.recycleModalDialog(this.val$dialog);
            }
        }

        /* synthetic */ 2(JDialog jDialog, JOptionPane jOptionPane) {
            this.val$dialog = jDialog;
            this.this$0 = jOptionPane;
        }
    }

    private static final class 3
    implements PropertyChangeListener {
        private final /* synthetic */ JOptionPane this$0;
        private final /* synthetic */ JInternalFrame val$iFrame;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.val$iFrame.isVisible() && propertyChangeEvent.getSource() == this.this$0 && (propertyChangeEvent.getPropertyName().equals(JOptionPane.VALUE_PROPERTY) || propertyChangeEvent.getPropertyName().equals(JOptionPane.INPUT_VALUE_PROPERTY))) {
                try {
                    this.val$iFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                this.val$iFrame.setVisible(false);
                this.val$iFrame.stopModal();
            }
        }

        /* synthetic */ 3(JInternalFrame jInternalFrame, JOptionPane jOptionPane) {
            this.val$iFrame = jInternalFrame;
            this.this$0 = jOptionPane;
        }
    }
}

