/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.Action;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ToolBarUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class JToolBar
extends JComponent
implements Accessible {
    private boolean paintBorder = true;
    private Insets margin;
    private boolean floatable = true;

    public JToolBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.updateUI();
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
    }

    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ToolBarUI";
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Component getComponentAtIndex(int n) {
        int n2 = this.getComponentCount();
        if (n <= n2) {
            Component[] componentArray = this.getComponents();
            return componentArray[n];
        }
        return null;
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.invalidate();
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.invalidate();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public void setFloatable(boolean bl) {
        if (this.floatable != bl) {
            this.floatable = bl;
            this.firePropertyChange("floatable", !this.floatable, this.floatable);
        }
    }

    public void addSeparator() {
        Separator separator = new Separator();
        this.add(separator);
    }

    public JButton add(Action action) {
        JButton jButton = new JButton((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        jButton.setEnabled(action.isEnabled());
        jButton.addActionListener(action);
        this.add(jButton);
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(jButton);
        action.addPropertyChangeListener(propertyChangeListener);
        return jButton;
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return new ActionChangedListener(jButton);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar();
        }
        return this.accessibleContext;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ActionChangedListener(JButton jButton) {
            JToolBar.this = JToolBar.this;
            this.button = jButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.button.setText(string2);
                this.button.repaint();
                return;
            }
            if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
                this.button.repaint();
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }
    }

    public class Separator
    extends Component {
        public Separator() {
            JToolBar.this = JToolBar.this;
        }

        public Dimension getMinimumSize() {
            return new Dimension(10, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(10, 5);
        }

        public Dimension getPreferredSize() {
            return new Dimension(10, 5);
        }
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JToolBar.this);
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }

        AccessibleJToolBar() {
            JToolBar.this = JToolBar.this;
        }
    }
}

