/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.ComboBoxEditor;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.plaf.ComboBoxUI;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicArrowButton;
import com.sun.java.swing.plaf.basic.BasicComboPopup;
import com.sun.java.swing.plaf.basic.ComboPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicComboBoxUI
extends ComboBoxUI
implements Serializable {
    protected JComboBox comboBox;
    protected boolean hasFocus = false;
    protected JList listBox;
    protected CellRendererPane currentValuePane = new CellRendererPane();
    protected ComboPopup popup;
    protected Component editor;
    protected JButton arrowButton;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected ItemListener itemListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected KeyListener popupKeyListener;
    protected ListDataListener listDataListener;
    protected boolean isMinimumSizeDirty = true;
    protected Dimension cachedMinimumSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)jComponent;
        this.installDefaults(jComponent);
        this.listBox = this.createListBox();
        this.popup = this.createPopup();
        this.popupMouseListener = this.popup.getMouseListener();
        this.popupMouseMotionListener = this.popup.getMouseMotionListener();
        this.popupKeyListener = this.popup.getKeyListener();
        this.keyListener = this.createKeyListener();
        this.focusListener = this.createFocusListener();
        this.listDataListener = this.createListDataListener();
        this.itemListener = this.createItemListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.addSubComponents();
        this.installListeners(jComponent);
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        JComboBox jComboBox = this.comboBox;
        1 var3_3 = new 1(jComboBox, this);
        SwingUtilities.invokeLater(var3_3);
    }

    public void uninstallUI(JComponent jComponent) {
        this.popup.hide();
        this.popup.uninstallingUI();
        this.removeKeyAccelerators(jComponent);
        this.comboBox.setLayout(null);
        this.comboBox.resetKeyboardActions();
        this.comboBox.remove(this.currentValuePane);
        this.removeSubComponents();
        this.removeListeners(jComponent);
        this.comboBox = null;
        this.popup = null;
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.popupKeyListener = null;
        this.popupMouseListener = null;
        this.popupMouseMotionListener = null;
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer((ListCellRenderer)UIManager.get("ComboBox.renderer"));
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor((ComboBoxEditor)UIManager.get("ComboBox.editor"));
        }
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    protected void installListeners(JComponent jComponent) {
        this.comboBox.addItemListener(this.itemListener);
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.comboBox.addKeyListener(this.keyListener);
        this.comboBox.addFocusListener(this.focusListener);
        this.comboBox.addMouseListener(this.popupMouseListener);
        this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        this.comboBox.addKeyListener(this.popupKeyListener);
        if (this.comboBox.getModel() != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    protected void removeListeners(JComponent jComponent) {
        this.comboBox.removeItemListener(this.itemListener);
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.comboBox.removeKeyListener(this.keyListener);
        this.comboBox.removeFocusListener(this.focusListener);
        this.comboBox.removeMouseListener(this.popupMouseListener);
        this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        this.comboBox.removeKeyListener(this.popupKeyListener);
        if (this.comboBox.getModel() != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    protected JList createListBox() {
        return new JList();
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new SelectionChangeKeyListener();
    }

    protected FocusListener createFocusListener() {
        return new ComboBoxFocusListener();
    }

    protected ListDataListener createListDataListener() {
        return new ComboBoxListDataListener();
    }

    protected ItemListener createItemListener() {
        return new ComboBoxItemListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new ComboBoxPropertyChangeListener();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected void addSubComponents() {
        this.arrowButton = this.createArrowButton();
        this.configureArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void removeSubComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        this.comboBox.add(this.editor);
        if (this.editor != null) {
            this.configureEditor();
        }
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
        }
    }

    protected void configureEditor() {
        this.editor.setFont(this.comboBox.getFont());
        this.editor.addKeyListener(this.popupKeyListener);
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
        this.editor.removeKeyListener(this.popupKeyListener);
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setRequestFocusEnabled(false);
            this.arrowButton.addMouseListener(this.popupMouseListener);
            this.arrowButton.addMouseMotionListener(this.popupMouseMotionListener);
            this.arrowButton.resetKeyboardActions();
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popupMouseListener);
            this.arrowButton.removeMouseMotionListener(this.popupMouseMotionListener);
        }
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5);
    }

    public boolean popupIsVisible() {
        return this.popup.isVisible();
    }

    public void showPopup() {
        this.popup.show();
    }

    public void hidePopup() {
        this.popup.hide();
    }

    public boolean isFocusTraversable() {
        return !this.comboBox.isEditable();
    }

    public JList getList() {
        return this.listBox;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getMinimumSize(jComponent);
        dimension.width += 4;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getDisplaySize();
        dimension.height += insets.top + insets.bottom;
        int n = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    protected boolean isNavigationKey(int n) {
        return n == 38 || n == 40;
    }

    protected void selectNextPossibleValue() {
        int n = this.comboBox.getSelectedIndex();
        if (n < this.comboBox.getModel().getSize() - 1) {
            this.comboBox.setSelectedIndex(n + 1);
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.comboBox.getSelectedIndex();
        if (n > 0) {
            this.comboBox.setSelectedIndex(n - 1);
            this.comboBox.repaint();
        }
    }

    protected void toggleOpenClose() {
        if (this.popupIsVisible()) {
            this.popup.hide();
            return;
        }
        this.popup.show();
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (bl && !this.popupIsVisible()) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.popupIsVisible()) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(UIManager.getColor("ComboBox.background"));
        } else {
            graphics.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    void repaintCurrentValue() {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.comboBox.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Dimension getDefaultSize() {
        return new Dimension(100, 20);
    }

    protected Dimension getDisplaySize() {
        Dimension dimension = new Dimension();
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        ComboBoxModel comboBoxModel = this.comboBox.getModel();
        if (listCellRenderer != null && comboBoxModel.getSize() > 0) {
            Dimension dimension2;
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(n), -1, false, false);
                this.currentValuePane.add(component);
                component.setFont(this.comboBox.getFont());
                dimension2 = component.getPreferredSize();
                this.currentValuePane.remove(component);
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
                ++n;
            }
            if (this.comboBox.isEditable()) {
                dimension2 = this.editor.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension;
        }
        return this.getDefaultSize();
    }

    protected void addKeyAccelerators(JComponent jComponent) {
        2 var2_2 = new 2();
        jComponent.registerKeyboardAction(var2_2, KeyStroke.getKeyStroke(10, 0), 1);
        3 var3_3 = new 3();
        jComponent.registerKeyboardAction(var3_3, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected void removeKeyAccelerators(JComponent jComponent) {
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ JComboBox val$cBox;
        private final /* synthetic */ BasicComboBoxUI this$0;

        public void run() {
            if (this.this$0.comboBox != null) {
                if (this.this$0.editor != null) {
                    this.this$0.editor.setFont(this.val$cBox.getFont());
                }
                this.this$0.addKeyAccelerators(this.val$cBox);
            }
        }

        /* synthetic */ 1(JComboBox jComboBox, BasicComboBoxUI basicComboBoxUI) {
            this.val$cBox = jComboBox;
            this.this$0 = basicComboBoxUI;
        }
    }

    protected class SelectionChangeKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (BasicComboBoxUI.this.comboBox.isEnabled() && !BasicComboBoxUI.this.isNavigationKey(keyEvent.getKeyCode()) && BasicComboBoxUI.this.comboBox.selectWithKeyChar(keyEvent.getKeyChar())) {
                keyEvent.consume();
            }
        }

        SelectionChangeKeyListener() {
            BasicComboBoxUI.this = BasicComboBoxUI.this;
        }
    }

    protected class ComboBoxFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicComboBoxUI.this.comboBox.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                BasicComboBoxUI.this.popup.hide();
            }
            BasicComboBoxUI.this.comboBox.repaint();
        }

        ComboBoxFocusListener() {
            BasicComboBoxUI.this = BasicComboBoxUI.this;
        }
    }

    protected class ComboBoxListDataListener
    implements ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicComboBoxUI.this.isMinimumSizeDirty = true;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        ComboBoxListDataListener() {
            BasicComboBoxUI.this = BasicComboBoxUI.this;
        }
    }

    protected class ComboBoxItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            ComboBoxModel comboBoxModel = BasicComboBoxUI.this.comboBox.getModel();
            Object object = comboBoxModel.getSelectedItem();
            if (BasicComboBoxUI.this.editor != null) {
                BasicComboBoxUI.this.comboBox.configureEditor(BasicComboBoxUI.this.comboBox.getEditor(), object);
                return;
            }
            Rectangle rectangle = BasicComboBoxUI.this.rectangleForCurrentValue();
            BasicComboBoxUI.this.comboBox.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        ComboBoxItemListener() {
            BasicComboBoxUI.this = BasicComboBoxUI.this;
        }
    }

    public class ComboBoxPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                if (BasicComboBoxUI.this.listBox != null) {
                    BasicComboBoxUI.this.listBox.setModel(BasicComboBoxUI.this.comboBox.getModel());
                    if (BasicComboBoxUI.this.popupIsVisible()) {
                        BasicComboBoxUI.this.popup.hide();
                        return;
                    }
                }
            } else {
                if (string.equals("editor") && BasicComboBoxUI.this.comboBox.isEditable()) {
                    BasicComboBoxUI.this.removeEditor();
                    BasicComboBoxUI.this.addEditor();
                    return;
                }
                if (string.equals("editable")) {
                    if (BasicComboBoxUI.this.comboBox.isEditable()) {
                        BasicComboBoxUI.this.comboBox.setRequestFocusEnabled(false);
                        BasicComboBoxUI.this.comboBox.removeKeyListener(BasicComboBoxUI.this.popupKeyListener);
                        BasicComboBoxUI.this.addEditor();
                        return;
                    }
                    BasicComboBoxUI.this.comboBox.setRequestFocusEnabled(true);
                    BasicComboBoxUI.this.comboBox.addKeyListener(BasicComboBoxUI.this.popupKeyListener);
                    BasicComboBoxUI.this.removeEditor();
                    return;
                }
                if (string.equals("enabled")) {
                    boolean bl = BasicComboBoxUI.this.comboBox.isEnabled();
                    if (bl) {
                        if (BasicComboBoxUI.this.editor != null) {
                            BasicComboBoxUI.this.editor.setEnabled(true);
                        }
                        if (BasicComboBoxUI.this.arrowButton != null) {
                            BasicComboBoxUI.this.arrowButton.setEnabled(true);
                        }
                    } else {
                        if (BasicComboBoxUI.this.editor != null) {
                            BasicComboBoxUI.this.editor.setEnabled(false);
                        }
                        if (BasicComboBoxUI.this.arrowButton != null) {
                            BasicComboBoxUI.this.arrowButton.setEnabled(false);
                        }
                    }
                    BasicComboBoxUI.this.comboBox.repaint();
                    return;
                }
                if (string.equals("maximumRowCount") && BasicComboBoxUI.this.popupIsVisible()) {
                    BasicComboBoxUI.this.popup.hide();
                    BasicComboBoxUI.this.popup.show();
                }
            }
        }

        public ComboBoxPropertyChangeListener() {
            BasicComboBoxUI.this = BasicComboBoxUI.this;
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            JComboBox cfr_ignored_0 = (JComboBox)container;
            return container.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            JComboBox cfr_ignored_0 = (JComboBox)container;
            return container.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = BasicComboBoxUI.this.getInsets();
            int n3 = n2 - (insets.top + insets.bottom);
            if (BasicComboBoxUI.this.editor != null) {
                Rectangle rectangle = BasicComboBoxUI.this.rectangleForCurrentValue();
                BasicComboBoxUI.this.editor.setBounds(rectangle);
            }
            if (BasicComboBoxUI.this.arrowButton != null) {
                BasicComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n3);
            }
        }

        public ComboBoxLayoutManager() {
            BasicComboBoxUI.this = BasicComboBoxUI.this;
        }
    }

    private final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.popup.hide();
        }

        public boolean isEnabled() {
            return BasicComboBoxUI.this.comboBox.isEnabled();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicComboBoxUI.this.popup.hide();
        }

        public boolean isEnabled() {
            return BasicComboBoxUI.this.comboBox.isEnabled();
        }

        /* synthetic */ 3() {
        }
    }
}

