/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview;

import com.sun.java.accessibility.Accessible;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.FileChooserUI;
import com.sun.java.swing.preview.filechooser.FileFilter;
import com.sun.java.swing.preview.filechooser.FileSystemView;
import com.sun.java.swing.preview.filechooser.FileView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

public class JFileChooser
extends JComponent
implements Accessible {
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = 0;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "ApproveSelection";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    private String dialogTitle;
    private String approveButtonText;
    private String approveButtonToolTipText;
    private ActionListener actionListener;
    private Vector filters = new Vector(5);
    private JDialog dialog;
    private int dialogType = 0;
    private int returnValue = 0;
    private JComponent accessory;
    private FileView fileView;
    private FileView uiFileView;
    private boolean useFileHiding = true;
    private int fileSelectionMode = 0;
    private boolean multiSelectionEnabled = false;
    private FileFilter fileFilter;
    private FileSystemView fileSystemView;
    private File currentDirectory;
    private File selectedFile;
    private File[] selectedFiles;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JFileChooser() {
        this((File)null);
    }

    public JFileChooser(String string) {
        this.init();
        this.setCurrentDirectory(this.getFileSystemView().createFileObject(string));
        this.setFileFilter(this.getAcceptAllFileFilter());
    }

    public JFileChooser(File file) {
        this.init();
        this.setCurrentDirectory(file);
        this.setFileFilter(this.getAcceptAllFileFilter());
    }

    protected void init() {
        this.setFileSystemView(FileSystemView.getFileSystemView());
        this.updateUI();
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        File file2 = this.selectedFile;
        this.selectedFile = file;
        this.ensureFileIsVisible(file);
        this.firePropertyChange("ApproveSelection", file2, this.selectedFile);
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles == null) {
            return new File[0];
        }
        return (File[])this.selectedFiles.clone();
    }

    public void setSelectedFiles(File[] fileArray) {
        this.selectedFiles = fileArray;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        if (this.currentDirectory == file && file != null) {
            return;
        }
        File file2 = this.currentDirectory;
        if (file == null) {
            this.currentDirectory = this.getFileSystemView().createFileObject(System.getProperty("user.home"));
        } else {
            File file3 = null;
            while (!this.isTraversable(file) && file3 != file && !this.getFileSystemView().isRoot(file)) {
                file3 = file;
                file = this.getFileSystemView().getParentDirectory(file);
            }
            this.currentDirectory = file;
        }
        this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, file2, this.currentDirectory);
    }

    public void changeToParentDirectory() {
        File file = this.getCurrentDirectory();
        this.setCurrentDirectory(this.getFileSystemView().getParentDirectory(file));
    }

    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory();
    }

    public void ensureFileIsVisible(File file) {
        this.getUI().ensureFileIsVisible(file);
    }

    public int showOpenDialog(Component component) {
        this.setDialogType(0);
        return this.showDialog(component, null);
    }

    public int showSaveDialog(Component component) {
        this.setDialogType(1);
        return this.showDialog(component, null);
    }

    public int showDialog(Component component, String string) {
        if (string != null) {
            this.setApproveButtonText(string);
        }
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = JFileChooser.class$("java.awt.Frame")), component);
        this.dialog = new JDialog(frame, this.getDialogTitle(), true);
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(component);
        this.dialog.show();
        return this.returnValue;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int n) {
        if (this.dialogType == n) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + n);
        }
        int n2 = this.dialogType;
        this.dialogType = n;
        if (n == 0 || n == 1) {
            this.setApproveButtonText(null);
        }
        this.firePropertyChange(DIALOG_TYPE_CHANGED_PROPERTY, n2, n);
    }

    public void setDialogTitle(String string) {
        this.dialogTitle = string;
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setApproveButtonToolTipText(String string) {
        if (this.approveButtonToolTipText == string) {
            return;
        }
        String string2 = this.approveButtonToolTipText;
        this.approveButtonToolTipText = string;
        this.setDialogType(2);
        this.firePropertyChange(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY, string2, this.approveButtonToolTipText);
    }

    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    public void setApproveButtonText(String string) {
        if (this.approveButtonText == string) {
            return;
        }
        String string2 = this.approveButtonText;
        this.approveButtonText = string;
        this.setDialogType(2);
        this.firePropertyChange(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY, string2, string);
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public FileFilter[] getChoosableFileFilters() {
        Object[] objectArray = new FileFilter[this.filters.size()];
        this.filters.copyInto(objectArray);
        return objectArray;
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        if (!this.filters.contains(fileFilter)) {
            FileFilter[] fileFilterArray = this.getChoosableFileFilters();
            this.filters.addElement(fileFilter);
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, this.getChoosableFileFilters());
        }
    }

    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        if (this.filters.contains(fileFilter)) {
            FileFilter[] fileFilterArray = this.getChoosableFileFilters();
            this.filters.removeElement(fileFilter);
            this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, this.getChoosableFileFilters());
            return true;
        }
        return false;
    }

    public void resetChoosableFileFilters() {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        this.filters.removeAllElements();
        this.filters.addElement(this.getAcceptAllFileFilter());
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, this.getChoosableFileFilters());
    }

    public FileFilter getAcceptAllFileFilter() {
        FileFilter fileFilter = null;
        if (this.getUI() != null) {
            fileFilter = this.getUI().getAcceptAllFileFilter();
        }
        return fileFilter;
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent jComponent) {
        JComponent jComponent2 = this.accessory;
        this.accessory = jComponent;
        this.firePropertyChange(ACCESSORY_CHANGED_PROPERTY, jComponent2, this.accessory);
    }

    public void setFileSelectionMode(int n) {
        if (this.fileSelectionMode == n) {
            return;
        }
        int n2 = this.fileSelectionMode;
        this.fileSelectionMode = n;
        this.firePropertyChange(FILE_SELECTION_MODE_CHANGED_PROPERTY, n2, this.fileSelectionMode);
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    public void setMultiSelectionEnabled(boolean bl) {
        if (this.multiSelectionEnabled == bl) {
            return;
        }
        boolean bl2 = this.multiSelectionEnabled;
        this.multiSelectionEnabled = bl;
        this.firePropertyChange("fileFilterChanged", bl2, this.multiSelectionEnabled);
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public boolean isFileHidingEnabled() {
        return this.useFileHiding;
    }

    public void setFileHidingEnabled(boolean bl) {
        boolean bl2 = this.useFileHiding;
        this.useFileHiding = bl;
        this.firePropertyChange(FILE_HIDING_CHANGED_PROPERTY, bl2, this.useFileHiding);
    }

    public void setFileFilter(FileFilter fileFilter) {
        FileFilter fileFilter2 = this.fileFilter;
        this.fileFilter = fileFilter;
        this.firePropertyChange("fileFilterChanged", fileFilter2, this.fileFilter);
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileView(FileView fileView) {
        FileView fileView2 = this.fileView;
        this.fileView = fileView;
        this.firePropertyChange(FILE_VIEW_CHANGED_PROPERTY, fileView2, fileView);
    }

    public FileView getFileView() {
        return this.fileView;
    }

    public String getName(File file) {
        String string = null;
        if (this.getFileView() != null) {
            string = this.getFileView().getName(file);
        }
        if (string == null && this.uiFileView != null) {
            string = this.uiFileView.getName(file);
        }
        return string;
    }

    public String getDescription(File file) {
        String string = null;
        if (this.getFileView() != null) {
            string = this.getFileView().getDescription(file);
        }
        if (string == null && this.uiFileView != null) {
            string = this.uiFileView.getDescription(file);
        }
        return string;
    }

    public String getTypeDescription(File file) {
        String string = null;
        if (this.getFileView() != null) {
            string = this.getFileView().getTypeDescription(file);
        }
        if (string == null && this.uiFileView != null) {
            string = this.uiFileView.getTypeDescription(file);
        }
        return string;
    }

    public Icon getIcon(File file) {
        Icon icon = null;
        if (this.getFileView() != null) {
            icon = this.getFileView().getIcon(file);
        }
        if (icon == null && this.uiFileView != null) {
            icon = this.uiFileView.getIcon(file);
        }
        return icon;
    }

    public boolean isTraversable(File file) {
        Boolean bl = null;
        if (this.getFileView() != null) {
            bl = this.getFileView().isTraversable(file);
        }
        if (bl == null && this.uiFileView != null) {
            bl = this.uiFileView.isTraversable(file);
        }
        if (bl == null && file != null) {
            bl = file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
        } else if (bl == null) {
            return false;
        }
        return bl;
    }

    public boolean accept(File file) {
        boolean bl = true;
        if (this.fileFilter != null) {
            bl = this.fileFilter.accept(file);
        }
        return bl;
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        FileSystemView fileSystemView2 = this.fileSystemView;
        this.fileSystemView = fileSystemView;
        this.firePropertyChange(FILE_SYSTEM_VIEW_CHANGED_PROPERTY, fileSystemView2, fileSystemView);
    }

    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public void approveSelection() {
        this.returnValue = 0;
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
        this.fireActionPerformed("ApproveSelection");
    }

    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JFileChooser.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JFileChooser.class$("java.awt.event.ActionListener")), actionListener);
    }

    protected void fireActionPerformed(String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JFileChooser.class$("java.awt.event.ActionListener"))) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, string);
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public void updateUI() {
        this.setUI((FileChooserUI)UIManager.getUI(this));
        this.uiFileView = this.getUI().getFileView();
        boolean bl = this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        if (bl) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
    }

    public String getUIClassID() {
        return "FileChooserUI";
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.ui;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

