/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.StyleConstants;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class SimpleAttributeSet
implements MutableAttributeSet,
Serializable {
    public static final AttributeSet EMPTY = new SimpleAttributeSet();
    private Hashtable table = new Hashtable(3);

    public SimpleAttributeSet() {
    }

    public SimpleAttributeSet(AttributeSet attributeSet) {
        this.addAttributes(attributeSet);
    }

    private SimpleAttributeSet(Hashtable hashtable) {
        this.table = hashtable;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int getAttributeCount() {
        return this.table.size();
    }

    public boolean isDefined(Object object) {
        return this.table.containsKey(object);
    }

    public boolean isEqual(AttributeSet attributeSet) {
        return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    public AttributeSet copyAttributes() {
        return (AttributeSet)this.clone();
    }

    public Enumeration getAttributeNames() {
        return this.table.keys();
    }

    public Object getAttribute(Object object) {
        AttributeSet attributeSet;
        Object object2 = this.table.get(object);
        if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
            object2 = attributeSet.getAttribute(object);
        }
        return object2;
    }

    public boolean containsAttribute(Object object, Object object2) {
        return object2.equals(this.getAttribute(object));
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        boolean bl = true;
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (bl && enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            bl = attributeSet.getAttribute(e).equals(this.getAttribute(e));
        }
        return bl;
    }

    public void addAttribute(Object object, Object object2) {
        this.table.put(object, object2);
    }

    public void addAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.addAttribute(e, attributeSet.getAttribute(e));
        }
    }

    public void removeAttribute(Object object) {
        this.table.remove(object);
    }

    public void removeAttributes(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeAttribute(enumeration.nextElement());
        }
    }

    public void removeAttributes(AttributeSet attributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = attributeSet.getAttribute(e);
            if (!object.equals(this.getAttribute(e))) continue;
            this.removeAttribute(e);
        }
    }

    public AttributeSet getResolveParent() {
        return (AttributeSet)this.table.get(StyleConstants.ResolveAttribute);
    }

    public void setResolveParent(AttributeSet attributeSet) {
        this.addAttribute(StyleConstants.ResolveAttribute, attributeSet);
    }

    public Object clone() {
        return new SimpleAttributeSet((Hashtable)this.table.clone());
    }

    public int hashCode() {
        return ((Object)this.table).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeSet) {
            AttributeSet attributeSet = (AttributeSet)object;
            return this.isEqual(attributeSet);
        }
        return false;
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = this.getAttribute(e);
            string = object instanceof AttributeSet ? String.valueOf(string) + e + "=**AttributeSet** " : String.valueOf(string) + e + "=" + object + " ";
        }
        return string;
    }
}

