/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.undo;

import com.sun.java.swing.undo.AbstractUndoableEdit;
import com.sun.java.swing.undo.CannotRedoException;
import com.sun.java.swing.undo.CannotUndoException;
import com.sun.java.swing.undo.UndoableEdit;
import java.util.Enumeration;
import java.util.Vector;

public class CompoundEdit
extends AbstractUndoableEdit {
    boolean inProgress = true;
    protected Vector edits = new Vector();

    public void undo() throws CannotUndoException {
        super.undo();
        int n = this.edits.size();
        while (n-- > 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n);
            undoableEdit.undo();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            ((UndoableEdit)enumeration.nextElement()).redo();
        }
    }

    protected UndoableEdit lastEdit() {
        int n = this.edits.size();
        if (n > 0) {
            return (UndoableEdit)this.edits.elementAt(n - 1);
        }
        return null;
    }

    public void die() {
        int n = this.edits.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n2);
            undoableEdit.die();
            --n2;
        }
        super.die();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.addElement(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(undoableEdit);
        }
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            if (!((UndoableEdit)enumeration.nextElement()).isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return super.getPresentationName();
    }

    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

