/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.layout;

import com.borland.jbcl.layout.PaneConstraints;
import com.borland.jbcl.layout.PaneNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class PaneLayout
implements Serializable,
LayoutManager2 {
    private int addCount = 0;
    private String lastComponentAdded;
    int gap = 0;
    private PaneNode lastDeletion;
    PaneNode lastSelected;
    PaneNode rootNode;
    private static final long serialVersionUID = 200L;

    boolean justDeleted(Component component, PaneConstraints paneConstraints) {
        if (this.lastDeletion == null || paneConstraints == null) {
            return false;
        }
        if (this.lastDeletion.childComponent == component) {
            if (this.lastDeletion.childNodeA == null) {
                PaneNode paneNode = this.lastDeletion.childNodeB;
                if (paneNode == null) {
                    return false;
                }
                if (paneConstraints.splitComponentName != null && paneConstraints.splitComponentName.equals(paneNode.getNodeAComponent()) || !this.lastDeletion.name.equals(paneConstraints.name)) {
                    PaneNode paneNode2 = new PaneNode(paneNode.childNodeA, paneNode.childNodeB, "", 0.5f);
                    paneNode2.widthDivide = paneNode.widthDivide;
                    paneNode2.heightDivide = paneNode.heightDivide;
                    paneNode2.name = paneNode.name;
                    this.lastDeletion.name = paneConstraints.name;
                    paneNode2.childComponent = paneNode.childComponent;
                    if (paneNode2.childComponent != null) {
                        paneNode2.childNodeA = null;
                        paneNode2.childNodeB = null;
                    }
                    paneNode2.reverse = paneNode.reverse;
                    paneNode2.horizontal = paneNode.horizontal;
                    paneNode.childNodeA = paneNode2;
                    paneNode.childNodeB = this.lastDeletion;
                    paneNode.name = null;
                    paneNode.childComponent = null;
                    paneNode.widthDivide = this.lastDeletion.widthDivide;
                    paneNode.heightDivide = this.lastDeletion.heightDivide;
                    paneNode.reverse = this.lastDeletion.reverse;
                    paneNode.horizontal = this.lastDeletion.horizontal;
                    this.lastDeletion = null;
                    this.setConstraints(component, paneConstraints);
                    return true;
                }
            } else {
                PaneNode paneNode = this.lastDeletion.childNodeA;
                PaneNode paneNode3 = new PaneNode(paneNode.childNodeA, paneNode.childNodeB, "", 0.5f);
                paneNode3.widthDivide = paneNode.widthDivide;
                paneNode3.heightDivide = paneNode.heightDivide;
                paneNode3.name = paneNode.name;
                this.lastDeletion.name = paneConstraints.name;
                paneNode3.childComponent = paneNode.childComponent;
                if (paneNode3.childComponent != null) {
                    paneNode3.childNodeA = null;
                    paneNode3.childNodeB = null;
                }
                paneNode3.reverse = paneNode.reverse;
                paneNode3.horizontal = paneNode.horizontal;
                paneNode.childNodeA = this.lastDeletion;
                paneNode.childNodeB = paneNode3;
                paneNode.name = null;
                paneNode.childComponent = null;
                paneNode.widthDivide = this.lastDeletion.widthDivide;
                paneNode.heightDivide = this.lastDeletion.heightDivide;
                paneNode.reverse = this.lastDeletion.reverse;
                paneNode.horizontal = this.lastDeletion.horizontal;
                this.lastDeletion = null;
                this.setConstraints(component, paneConstraints);
                return true;
            }
            this.lastDeletion = null;
        }
        return false;
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(500, 500);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null && component.getName() != null && component.getName().equals("SplitPanel.splitter")) {
            return;
        }
        if (object instanceof PaneConstraints) {
            if (!this.justDeleted(component, (PaneConstraints)object)) {
                Object object2;
                if (((PaneConstraints)object).name == null) {
                    ++this.addCount;
                    object2 = String.valueOf("component").concat(String.valueOf(this.addCount));
                }
                if (this.setComponentConstraints(component, (PaneConstraints)object)) {
                    this.lastDeletion = null;
                    return;
                }
                object2 = (PaneConstraints)object;
                this.addChild(((PaneConstraints)object2).name, ((PaneConstraints)object2).splitComponentName, ((PaneConstraints)object2).position, component, ((PaneConstraints)object2).proportion);
                this.lastComponentAdded = ((PaneConstraints)object2).name;
            }
        } else {
            this.addChild(component, 0.5f);
        }
        this.lastDeletion = null;
    }

    public void addLayoutComponent(String string, Component component) {
        PaneConstraints paneConstraints = new PaneConstraints(string, "", "", 0.5f);
        this.addLayoutComponent(component, paneConstraints);
    }

    void addChild(String string, String string2, String string3, Component component, float f) {
        if (this.rootNode == null) {
            this.rootNode = new PaneNode(string, component, "Top");
        } else {
            boolean bl = true;
            if (string2 == null || string2.length() == 0) {
                if (string3 == null) {
                    this.rootNode.addChild(string, component, null, f);
                } else {
                    bl = this.rootNode.addChildSplit(string, this.lastComponentAdded, string3, component, f);
                }
            } else if (!this.rootNode.addChildSplit(string, string2, string3, component, f)) {
                bl = this.rootNode.addChildSplit(string, this.lastComponentAdded, string3, component, f);
            }
            if (!bl) {
                this.rootNode.addChild(string, component, string3, f);
            }
        }
    }

    public Rectangle getDividerRect(int n, int n2) {
        if (this.rootNode != null) {
            this.lastSelected = this.rootNode.hitTest(n, n2, this.gap * 2);
        }
        if (this.lastSelected != null) {
            return this.lastSelected.getDividerRect(this.gap * 2);
        }
        return null;
    }

    public Rectangle getDividerBounds() {
        if (this.lastSelected != null) {
            return this.lastSelected.location;
        }
        return null;
    }

    public void dragDivider(int n, int n2) {
        if (this.lastSelected != null) {
            this.lastSelected.drag(n, n2);
        }
    }

    void addChild(Component component, float f) {
        ++this.addCount;
        String string = String.valueOf("component").concat(String.valueOf(this.addCount));
        if (this.rootNode == null) {
            this.rootNode = new PaneNode(string, component, "Top");
        } else {
            this.rootNode.addChild(string, component, "Bottom", f);
        }
        this.lastComponentAdded = string;
    }

    public String[] getAddOrder(Container container) {
        Component[] componentArray = container.getComponents();
        String[] stringArray = new String[componentArray.length];
        Point point = new Point(0, 0);
        if (this.rootNode != null) {
            if (this.rootNode.childComponent == null) {
                this.rootNode.getComponents(point, stringArray, true);
            } else {
                stringArray[0] = this.rootNode.name;
            }
        }
        return stringArray;
    }

    public void layoutContainer(Container container) {
        if (this.rootNode != null) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            this.rootNode.assertLocation(rectangle, this.gap);
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        if (this.rootNode != null) {
            Dimension dimension = this.rootNode.getPreferredSize(this.gap);
            dimension.width += insets.right + insets.left;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
        return new Dimension(10, 10);
    }

    public void removeLayoutComponent(Component component) {
        if (component == null) {
            this.lastDeletion = null;
            return;
        }
        if (this.rootNode != null) {
            if (this.rootNode.childComponent == component) {
                this.rootNode = null;
            } else {
                PaneNode paneNode = this.rootNode.getImmediateParent(component);
                if (paneNode != null) {
                    this.lastDeletion = paneNode.removeChild(component);
                }
            }
        }
    }

    public String toString() {
        return "PaneLayout";
    }

    public PaneConstraints getConstraints(Component component) {
        PaneNode paneNode;
        PaneConstraints paneConstraints = null;
        if (this.rootNode != null && (paneNode = this.rootNode.getParentNode(component, null)) != null) {
            if (paneNode.childComponent == component) {
                paneConstraints = new PaneConstraints(paneNode.name, paneNode.name, "Root", 0.5f);
            } else {
                float f = paneNode.heightDivide * paneNode.widthDivide;
                String string = paneNode.childNodeA.getNodeAComponent();
                String string2 = paneNode.childNodeB.getNodeAComponent();
                if (paneNode.childNodeA.childComponent == component) {
                    string2 = paneNode.childNodeB.name;
                }
                paneConstraints = paneNode.horizontal ? (paneNode.reverse ? new PaneConstraints(string2, string, "Top", 1.0f - f) : new PaneConstraints(string2, string, "Bottom", 1.0f - f)) : (paneNode.reverse ? new PaneConstraints(string2, string, "Left", 1.0f - f) : new PaneConstraints(string2, string, "Right", 1.0f - f));
                if (string2.equals(string)) {
                    paneConstraints.position = "Root";
                }
            }
        }
        return paneConstraints;
    }

    private boolean setComponentConstraints(Component component, PaneConstraints paneConstraints) {
        if (this.rootNode != null) {
            PaneNode paneNode = this.rootNode.getParentNode(component, null);
            if (paneNode != null) {
                paneNode.setConstraints(component, paneConstraints);
                return true;
            }
            return false;
        }
        this.rootNode = new PaneNode(paneConstraints.name, component, "Root");
        return true;
    }

    public void setConstraints(Component component, PaneConstraints paneConstraints) {
        this.setComponentConstraints(component, paneConstraints);
        this.lastDeletion = null;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }
}

