/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JTree;
import com.sun.java.swing.plaf.basic.AbstractTreeUI;
import com.sun.java.swing.plaf.basic.BasicTreeUI;
import com.sun.java.swing.plaf.basic.LargeTreeModelNode;
import com.sun.java.swing.tree.MutableTreeNode;
import com.sun.java.swing.tree.TreeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

class BasicLargeTreeModelNode
extends LargeTreeModelNode {
    public BasicLargeTreeModelNode(AbstractTreeUI abstractTreeUI, Object object, int n) {
        super(abstractTreeUI, object, n);
    }

    public void repaint() {
        ((BasicTreeUI)this.treeUI).repaintNode(this);
    }

    public void cancelEditing() {
        ((BasicTreeUI)this.treeUI).completeEditing(false, true, false);
    }

    public void modelChildCountChanged() {
        if (this.getRow() != -1) {
            this.repaint();
        }
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this.cancelEditing();
        super.insert(mutableTreeNode, n);
        if (this.getChildCount() == 1 && this.getRow() != -1) {
            this.repaint();
        }
    }

    public void remove(int n) {
        this.cancelEditing();
        super.remove(n);
        if (this.treeUI.getModel().getChildCount(this.getUserObject()) == 0 && this.getRow() != -1) {
            this.repaint();
        }
    }

    public void collapse(boolean bl) {
        this.cancelEditing();
        super.collapse(bl);
        if (bl && (this.children == null || this.children.size() == 0)) {
            this.repaint();
        }
    }

    public void expand(boolean bl) {
        this.cancelEditing();
        super.expand(bl);
        if (bl && (this.children == null || this.children.size() == 0)) {
            this.repaint();
        }
    }

    protected void paintNode(Hashtable hashtable, BasicTreeUI.BasicTreeUIPaintInfo basicTreeUIPaintInfo, int n, int n2, Object object, boolean bl, boolean bl2, LargeTreeModelNode largeTreeModelNode, int n3, LargeTreeModelNode largeTreeModelNode2) {
        int n4 = (basicTreeUIPaintInfo.levelOffset + n2) * basicTreeUIPaintInfo.totalIndent;
        int n5 = basicTreeUIPaintInfo.rowHeight * n;
        int n6 = basicTreeUIPaintInfo.rChildIndent;
        int n7 = n4 - (n6 - 1);
        int n8 = n5 + basicTreeUIPaintInfo.halfRowHeight;
        Color color = basicTreeUIPaintInfo.hashColor;
        Graphics graphics = basicTreeUIPaintInfo.g;
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.treeUI;
        TreeModel treeModel = basicTreeUIPaintInfo.treeModel;
        Component component = basicTreeUIPaintInfo.renderer.getTreeCellRendererComponent(basicTreeUIPaintInfo.tree, object, basicTreeUI.isRowSelected(n), bl2, bl, n, n == basicTreeUIPaintInfo.leadIndex);
        if (color != null) {
            graphics.setColor(color);
            if (n != 0 || basicTreeUIPaintInfo.levelOffset == 1) {
                basicTreeUI.drawHorizontalPartOfLeg(graphics, basicTreeUIPaintInfo.tree, n8, n7, n4);
            }
        }
        if (!(bl || largeTreeModelNode2 != null && treeModel.getChildCount(object) <= 0)) {
            if (bl2) {
                if (basicTreeUIPaintInfo.expandedIcon != null) {
                    this.cacheIconPainting(hashtable, basicTreeUIPaintInfo.expandedIcon, n7, n8);
                }
            } else if (basicTreeUIPaintInfo.collapsedIcon != null) {
                this.cacheIconPainting(hashtable, basicTreeUIPaintInfo.collapsedIcon, n7, n8);
            }
        }
        basicTreeUI.rendererPane.paintComponent(graphics, component, basicTreeUIPaintInfo.tree, n4, n5, component.getPreferredSize().width, basicTreeUIPaintInfo.rowHeight, true);
    }

    protected void cacheIconPainting(Hashtable hashtable, Icon icon, int n, int n2) {
        hashtable.put(new Point(n, n2), icon);
    }

    public static void paintCachedGraphics(Hashtable hashtable, Graphics graphics, JTree jTree, BasicTreeUI basicTreeUI) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Point point = (Point)enumeration.nextElement();
            Icon icon = (Icon)hashtable.get(point);
            basicTreeUI.drawCentered(jTree, graphics, icon, point.x, point.y);
        }
    }

    protected void paintChildren(Hashtable hashtable, BasicTreeUI.BasicTreeUIPaintInfo basicTreeUIPaintInfo, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.max(n3, n);
        int n8 = n7 - n + n6;
        int n9 = Math.min(n4, n2) - n + n6;
        while (n8 <= n9) {
            Object object = basicTreeUIPaintInfo.treeModel.getChild(this.getUserObject(), n8);
            this.paintNode(hashtable, basicTreeUIPaintInfo, n7, n5, object, basicTreeUIPaintInfo.treeModel.isLeaf(object), false, this, n8, null);
            ++n8;
            ++n7;
        }
    }

    protected boolean paint(Hashtable hashtable, BasicTreeUI.BasicTreeUIPaintInfo basicTreeUIPaintInfo, int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[0];
        if (nArray[0] >= n && nArray[0] <= n2) {
            this.paintNode(hashtable, basicTreeUIPaintInfo, nArray[0], n3, this.getUserObject(), false, this.isExpanded(), (LargeTreeModelNode)this.getParent(), this.getChildIndex(), this);
        }
        nArray[0] = nArray[0] + 1;
        if (nArray[0] > n2) {
            return true;
        }
        ++n3;
        if (this.isExpanded) {
            int n5;
            int n6;
            int n7 = 0;
            int n8 = nArray[0];
            int n9 = basicTreeUIPaintInfo.treeModel.getChildCount(this.getUserObject()) - 1;
            int n10 = -1;
            int n11 = 0;
            int n12 = this.getChildCount();
            while (n11 < n12) {
                BasicLargeTreeModelNode basicLargeTreeModelNode = (BasicLargeTreeModelNode)this.getChildAt(n11);
                n6 = basicLargeTreeModelNode.childIndex;
                if (n6 != n7) {
                    n5 = n6 - n7 + n8 - 1;
                    if (n8 <= n2 && (n5 >= n || n5 <= n2)) {
                        this.paintChildren(hashtable, basicTreeUIPaintInfo, n8, n5, n, n2, n3, n7);
                    }
                }
                nArray[0] = nArray[0] + (n6 - n7);
                if (nArray[0] > n2) {
                    ((BasicTreeUI)this.treeUI).drawVerticalPartOfLeg(basicTreeUIPaintInfo.g, basicTreeUIPaintInfo.tree, n3 - 1, n4 * basicTreeUIPaintInfo.rowHeight, n2 * basicTreeUIPaintInfo.rowHeight, basicTreeUIPaintInfo.rowHeight, basicTreeUIPaintInfo.rowHeight);
                    return true;
                }
                if (n6 == n9) {
                    n10 = nArray[0];
                }
                basicLargeTreeModelNode.paint(hashtable, basicTreeUIPaintInfo, nArray, n, n2, n3);
                n8 = nArray[0];
                n7 = n6 + 1;
                ++n11;
            }
            n6 = basicTreeUIPaintInfo.treeModel.getChildCount(this.getUserObject()) - 1;
            if (n6 >= n7) {
                n5 = n6 - n7 + n8;
                if (n8 <= n2 && (n5 >= n || n5 <= n2)) {
                    this.paintChildren(hashtable, basicTreeUIPaintInfo, n8, n5, n, n2, n3, n7);
                }
                nArray[0] = nArray[0] + (n6 - n7 + 1);
            }
            if (n9 >= 0) {
                ((BasicTreeUI)this.treeUI).drawVerticalPartOfLeg(basicTreeUIPaintInfo.g, basicTreeUIPaintInfo.tree, n3 - 1, n4 * basicTreeUIPaintInfo.rowHeight, (n10 == -1 ? nArray[0] - 1 : n10) * basicTreeUIPaintInfo.rowHeight, basicTreeUIPaintInfo.rowHeight, basicTreeUIPaintInfo.rowHeight);
            }
        }
        return false;
    }

    public void paintAll(BasicTreeUI.BasicTreeUIPaintInfo basicTreeUIPaintInfo, int[] nArray, int n, int n2, int n3, BasicTreeUI basicTreeUI) {
        Hashtable hashtable = new Hashtable();
        this.paint(hashtable, basicTreeUIPaintInfo, nArray, n, n2, n3);
        BasicLargeTreeModelNode.paintCachedGraphics(hashtable, basicTreeUIPaintInfo.g, basicTreeUIPaintInfo.tree, basicTreeUI);
    }
}

