/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.DesktopManager;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDesktopPane;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.JLayeredPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.DesktopIconUI;
import com.sun.java.swing.plaf.motif.MotifDesktopIconUI;
import com.sun.java.swing.plaf.motif.MotifFrameBorder;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.EventListener;

public class MotifDesktopIconUI
extends DesktopIconUI
implements Serializable {
    JInternalFrame.JDesktopIcon desktopIcon;
    JInternalFrame frame;
    Icon defaultIcon;
    IconButton iconButton;
    IconLabel iconLabel;
    JPopupMenu systemMenu;
    EventListener mml;
    static final Font defaultTitleFont = new Font("SansSerif", 0, 12);
    String title;
    static final int LABEL_HEIGHT = 18;
    static final int LABEL_DIVIDER = 4;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
        this.frame = this.desktopIcon.getInternalFrame();
        this.setDefaultIcon(UIManager.getIcon("DesktopIcon.icon"));
        this.iconButton = new IconButton(this.defaultIcon);
        MotifInternalFrameTitlePane motifInternalFrameTitlePane = new MotifInternalFrameTitlePane(this.frame);
        this.systemMenu = motifInternalFrameTitlePane.getSystemMenu();
        this.iconButton.addActionListener(new 1());
        this.iconButton.addMouseListener(new 2());
        MotifFrameBorder motifFrameBorder = new MotifFrameBorder(this.desktopIcon);
        this.desktopIcon.setLayout(new BorderLayout());
        this.iconButton.setBorder(motifFrameBorder);
        this.desktopIcon.add((Component)this.iconButton, "Center");
        this.iconLabel = new IconLabel();
        this.iconLabel.setBorder(motifFrameBorder);
        this.desktopIcon.add((Component)this.iconLabel, "South");
        this.desktopIcon.setSize(this.desktopIcon.getPreferredSize());
        this.desktopIcon.validate();
        this.mml = new MotionListener();
        this.desktopIcon.addMouseMotionListener((MouseMotionListener)this.mml);
        this.desktopIcon.addMouseListener((MouseListener)this.mml);
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    public void uninstallUI(JComponent jComponent) {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconButton);
        this.desktopIcon.remove(this.iconLabel);
        this.desktopIcon.removeMouseMotionListener((MouseMotionListener)this.mml);
        this.desktopIcon.removeMouseListener((MouseListener)this.mml);
        this.desktopIcon = null;
        this.frame = null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        int n = this.defaultIcon.getIconWidth();
        int n2 = this.defaultIcon.getIconHeight() + 18 + 4;
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            n += border.getBorderInsets((Component)jInternalFrame).left + border.getBorderInsets((Component)jInternalFrame).right;
            n2 += border.getBorderInsets((Component)jInternalFrame).bottom + border.getBorderInsets((Component)jInternalFrame).top;
        }
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Insets getInsets(JComponent jComponent) {
        JInternalFrame jInternalFrame = this.desktopIcon.getInternalFrame();
        Border border = jInternalFrame.getBorder();
        if (border != null) {
            return border.getBorderInsets(jInternalFrame);
        }
        return new Insets(0, 0, 0, 0);
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MotifDesktopIconUI.this.systemMenu.show(MotifDesktopIconUI.this.iconButton, 0, MotifDesktopIconUI.this.desktopIcon.getHeight());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                try {
                    MotifDesktopIconUI.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                MotifDesktopIconUI.this.systemMenu.setVisible(false);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private class MotionListener
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;

        public void mouseReleased(MouseEvent mouseEvent) {
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = MotifDesktopIconUI.this.desktopIcon.getBounds();
            try {
                MotifDesktopIconUI.this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            if (MotifDesktopIconUI.this.desktopIcon.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)MotifDesktopIconUI.this.desktopIcon.getParent()).moveToFront(MotifDesktopIconUI.this.desktopIcon);
            }
            if (mouseEvent.getClickCount() > 1 && MotifDesktopIconUI.this.frame.isIconifiable() && MotifDesktopIconUI.this.frame.isIcon()) {
                try {
                    MotifDesktopIconUI.this.frame.setIcon(false);
                    return;
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JDesktopPane jDesktopPane;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            Insets insets = MotifDesktopIconUI.this.desktopIcon.getInsets();
            int n = ((JComponent)MotifDesktopIconUI.this.desktopIcon.getParent()).getWidth();
            int n2 = ((JComponent)MotifDesktopIconUI.this.desktopIcon.getParent()).getHeight();
            int n3 = this.startingBounds.x - (this._x - point.x);
            int n4 = this.startingBounds.y - (this._y - point.y);
            if (n3 + insets.left <= -this.__x) {
                n3 = -this.__x - insets.left;
            }
            if (n4 + insets.top <= -this.__y) {
                n4 = -this.__y - insets.top;
            }
            if (n3 + this.__x + insets.right > n) {
                n3 = n - this.__x - insets.right;
            }
            if (n4 + this.__y + insets.bottom > n2) {
                n4 = n2 - this.__y - insets.bottom;
            }
            if ((jDesktopPane = MotifDesktopIconUI.this.desktopIcon.getDesktopPane()) != null) {
                DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                desktopManager.setBoundsForFrame(MotifDesktopIconUI.this.desktopIcon, n3, n4, MotifDesktopIconUI.this.desktopIcon.getWidth(), MotifDesktopIconUI.this.desktopIcon.getHeight());
                return;
            }
            this.moveAndRepaint(MotifDesktopIconUI.this.desktopIcon, n3, n4, MotifDesktopIconUI.this.desktopIcon.getWidth(), MotifDesktopIconUI.this.desktopIcon.getHeight());
        }

        public void moveAndRepaint(JComponent jComponent, int n, int n2, int n3, int n4) {
            Rectangle rectangle = jComponent.getBounds();
            jComponent.setBounds(n, n2, n3, n4);
            SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
            jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        MotionListener() {
            MotifDesktopIconUI.this = MotifDesktopIconUI.this;
        }
    }

    class IconLabel
    extends JPanel {
        IconLabel() {
            MotifDesktopIconUI.this = MotifDesktopIconUI.this;
            ((Component)this).setFont(defaultTitleFont);
            this.addMouseMotionListener(new 3(this));
            this.addMouseListener(new 4(this));
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public Dimension getMinimumSize() {
            return new Dimension(MotifDesktopIconUI.this.defaultIcon.getIconWidth() + 1, 22);
        }

        public Dimension getPreferredSize() {
            String string = MotifDesktopIconUI.this.frame.getTitle();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(defaultTitleFont);
            int n = fontMetrics.stringWidth(string) + 4;
            return new Dimension(n, 22);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = this.getWidth() - 1;
            Color color = UIManager.getColor("inactiveCaptionBorder").darker().darker();
            graphics.setColor(color);
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics.drawLine(n - 1, 1, n - 1, 1);
            graphics.drawLine(n, 0, n, 0);
            graphics.setColor(UIManager.getColor("inactiveCaption"));
            graphics.fillRect(2, 1, n - 3, 19);
            graphics.setClip(2, 1, n - 4, 18);
            int n2 = 18 - graphics.getFontMetrics().getDescent();
            graphics.setColor(UIManager.getColor("inactiveCaptionText"));
            graphics.drawString(MotifDesktopIconUI.this.frame.getTitle(), 4, n2);
        }
    }

    class IconButton
    extends JButton {
        Icon icon;

        IconButton(Icon icon) {
            super(icon);
            MotifDesktopIconUI.this = MotifDesktopIconUI.this;
            this.icon = icon;
            this.addMouseMotionListener(new 5(this));
            this.addMouseListener(new 6(this));
        }

        void forwardEventToParent(MouseEvent mouseEvent) {
            this.getParent().dispatchEvent(new MouseEvent(this.getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        static /* synthetic */ MotifDesktopIconUI access$0(IconButton iconButton) {
            return iconButton.MotifDesktopIconUI.this;
        }
    }
}

