/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicFileChooserUI;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;
import com.sun.java.swing.preview.JFileChooser;
import com.sun.java.swing.preview.filechooser.FileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;

public class MotifFileChooserUI
extends BasicFileChooserUI {
    private FilterComboBoxModel filterComboBoxModel;
    protected JList directoryList;
    protected JList fileList;
    protected JTextField pathField;
    protected JComboBox filterComboBox;
    protected JTextField filenameTextField;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension WITH_ACC_PREF_SIZE = new Dimension(650, 450);
    private static Dimension PREF_SIZE = new Dimension(350, 450);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension PREF_ACC_SIZE = new Dimension(10, 10);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private JPanel directoryPanel = new JPanel();
    protected JButton approveButton;

    public MotifFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public String getDirectoryName() {
        return this.pathField.getText();
    }

    public void setDirectoryName(String string) {
        this.pathField.setText(string);
    }

    public void ensureFileIsVisible(File file) {
    }

    public void rescanCurrentDirectory() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("ApproveSelection")) {
            File file = (File)propertyChangeEvent.getNewValue();
            if (file != null) {
                this.setFileName(this.getFileChooser().getName(file));
                return;
            }
        } else if (string.equals("directoryChanged")) {
            this.directoryList.clearSelection();
            File file = this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                try {
                    this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getCanonicalPath());
                    return;
                }
                catch (IOException iOException) {
                    this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getAbsolutePath());
                    return;
                }
            }
        } else {
            if (string.equals("fileSelectionChanged")) {
                this.directoryList.clearSelection();
                return;
            }
            if (string == "AccessoryChangedProperty") {
                if (this.getAccessoryPanel() != null) {
                    JComponent jComponent;
                    if (propertyChangeEvent.getOldValue() != null) {
                        this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                    }
                    if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                        this.getAccessoryPanel().add((Component)jComponent, "Center");
                        this.getAccessoryPanel().setPreferredSize(PREF_ACC_SIZE);
                        this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
                        return;
                    }
                    this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                    this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
                    return;
                }
            } else if (string == "ApproveButtonTextChangedProperty" || string == "DialogTypeChangedProperty") {
                this.approveButton.setText(this.getApproveButtonText());
                this.approveButton.setToolTipText(this.getApproveButtonToolTipText());
            }
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifFileChooserUI((JFileChooser)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installComponents() {
        this.getFileChooser().setLayout(new BoxLayout(this.getFileChooser(), 1));
        this.getFileChooser().add(Box.createRigidArea(vstrut10));
        1 var1_1 = new 1();
        this.align(var1_1);
        var1_1.setLayout(new BoxLayout(var1_1, 1));
        this.getFileChooser().add(var1_1);
        JLabel jLabel = new JLabel("Enter path or folder name:");
        this.align(jLabel);
        var1_1.add(jLabel);
        File file = this.getFileChooser().getCurrentDirectory();
        String string = null;
        if (file != null) {
            string = file.getPath();
        }
        this.pathField = new JTextField(string);
        this.align(this.pathField);
        this.pathField.addActionListener(this.getUpdateAction());
        var1_1.add(this.pathField);
        var1_1.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(MAX_SIZE);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.align(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.align(jPanel2);
        jLabel = new JLabel("Filter");
        this.align(jLabel);
        jPanel2.add(jLabel);
        this.filterComboBox = new JComboBox();
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.getFileChooser().addPropertyChangeListener(this.filterComboBoxModel);
        this.align(this.filterComboBox);
        jPanel2.add(this.filterComboBox);
        jLabel = new JLabel("Folders");
        this.align(jLabel);
        jPanel2.add(jLabel);
        jPanel2.add(this.createDirectoryList());
        JPanel jPanel3 = new JPanel();
        this.align(jPanel3);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jLabel = new JLabel("Files");
        this.align(jLabel);
        jPanel3.add(jLabel);
        jPanel3.add(this.createFilesList());
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(hstrut10));
        jPanel.add(jPanel3);
        JPanel jPanel4 = this.getAccessoryPanel();
        JComponent jComponent = this.getFileChooser().getAccessory();
        if (jPanel4 != null) {
            if (jComponent == null) {
                jPanel4.setPreferredSize(ZERO_ACC_SIZE);
                jPanel4.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
                jPanel4.setPreferredSize(PREF_ACC_SIZE);
                jPanel4.setMaximumSize(MAX_SIZE);
            }
            this.align(jPanel4);
            jPanel.add(jPanel4);
        }
        var1_1.add(jPanel);
        var1_1.add(Box.createRigidArea(vstrut10));
        jLabel = new JLabel("Enter file name:");
        this.align(jLabel);
        var1_1.add(jLabel);
        this.filenameTextField = new JTextField();
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        this.align(this.filenameTextField);
        this.filenameTextField.setAlignmentX(0.0f);
        var1_1.add(this.filenameTextField);
        var1_1.add(Box.createRigidArea(vstrut10));
        this.getFileChooser().add(new JSeparator());
        this.getFileChooser().add(Box.createRigidArea(vstrut10));
        JPanel jPanel5 = new JPanel();
        this.align(jPanel5);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createGlue());
        this.approveButton = new 2(this.getApproveButtonText());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText());
        this.align(this.approveButton);
        this.approveButton.setMargin(buttonMargin);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        jPanel5.add(this.approveButton);
        jPanel5.add(Box.createGlue());
        3 var11_11 = new 3(this.updateButtonText);
        var11_11.setToolTipText(BasicFileChooserUI.updateButtonToolTipText);
        this.align(var11_11);
        var11_11.setMargin(buttonMargin);
        var11_11.addActionListener(this.getUpdateAction());
        jPanel5.add(var11_11);
        jPanel5.add(Box.createGlue());
        4 var12_12 = new 4(this.cancelButtonText);
        var12_12.setToolTipText(BasicFileChooserUI.cancelButtonToolTipText);
        this.align(var12_12);
        var12_12.setMargin(buttonMargin);
        var12_12.addActionListener(this.getCancelSelectionAction());
        jPanel5.add(var12_12);
        jPanel5.add(Box.createGlue());
        5 var13_13 = new 5(this.helpButtonText);
        var13_13.setToolTipText(BasicFileChooserUI.helpButtonToolTipText);
        this.align(var13_13);
        var13_13.setMargin(buttonMargin);
        var13_13.setEnabled(false);
        jPanel5.add(var13_13);
        jPanel5.add(Box.createGlue());
        this.getFileChooser().add(jPanel5);
        this.getFileChooser().add(Box.createRigidArea(vstrut10));
        this.getFileChooser().add(Box.createGlue());
    }

    public void uninstallUI(JComponent jComponent) {
        this.getFileChooser().removeAll();
        super.uninstallUI(jComponent);
    }

    protected void loadIcons() {
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        this.fileList.setModel(new MotifFileListModel());
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener());
        this.fileList.addMouseListener(this.createDoubleClickListener(this.fileList));
        this.align(this.fileList);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setPreferredSize(prefListSize);
        jScrollPane.setMaximumSize(MAX_SIZE);
        this.align(jScrollPane);
        return jScrollPane;
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryList.setModel(new MotifDirectoryListModel());
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.directoryList);
        jScrollPane.setMaximumSize(MAX_SIZE);
        jScrollPane.setPreferredSize(prefListSize);
        this.align(jScrollPane);
        return jScrollPane;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.getFileChooser().getAccessory() != null) {
            return WITH_ACC_PREF_SIZE;
        }
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void align(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        jComponent.setAlignmentY(0.0f);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    private final class 1
    extends JPanel {
        public Insets getInsets() {
            return insets;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }

    private final class 3
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
        }

        /* synthetic */ 3(String string) {
            super(string);
        }
    }

    private final class 4
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
        }

        /* synthetic */ 4(String string) {
            super(string);
        }
    }

    private final class 5
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
        }

        /* synthetic */ 5(String string) {
            super(string);
        }
    }

    protected class FileCellRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }

        FileCellRenderer() {
            MotifFileChooserUI.this = MotifFileChooserUI.this;
        }
    }

    protected class DirectoryCellRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)object));
            return this;
        }

        DirectoryCellRenderer() {
            MotifFileChooserUI.this = MotifFileChooserUI.this;
        }
    }

    protected class MotifDirectoryListModel
    extends AbstractListModel
    implements ListDataListener {
        public MotifDirectoryListModel() {
            MotifFileChooserUI.this = MotifFileChooserUI.this;
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        public int getSize() {
            return MotifFileChooserUI.this.getModel().getDirectories().size();
        }

        public Object getElementAt(int n) {
            return MotifFileChooserUI.this.getModel().getDirectories().elementAt(n);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    protected class MotifFileListModel
    extends AbstractListModel
    implements ListDataListener {
        public MotifFileListModel() {
            MotifFileChooserUI.this = MotifFileChooserUI.this;
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        public int getSize() {
            return MotifFileChooserUI.this.getModel().getFiles().size();
        }

        public boolean contains(Object object) {
            return MotifFileChooserUI.this.getModel().getFiles().contains(object);
        }

        public int indexOf(Object object) {
            return MotifFileChooserUI.this.getModel().getFiles().indexOf(object);
        }

        public Object getElementAt(int n) {
            return MotifFileChooserUI.this.getModel().getFiles().elementAt(n);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    public class FilterComboBoxRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }

        public FilterComboBoxRenderer() {
            MotifFileChooserUI.this = MotifFileChooserUI.this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            MotifFileChooserUI.this = MotifFileChooserUI.this;
            this.filters = MotifFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                MotifFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = MotifFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    MotifFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return MotifFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return MotifFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }
}

