/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicScrollBarUI;
import com.sun.java.swing.plaf.motif.MotifScrollBarButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class MotifScrollBarUI
extends BasicScrollBarUI {
    private static final Dimension minimumThumbSize = new Dimension(8, 8);
    private static final Dimension maximumThumbSize = new Dimension(4096, 4096);
    private static Color thumbHighlightColor;
    private static Color thumbShadowColor;
    private static Color thumbColor;
    private static Color trackColor;
    private static boolean scrollBarColorsInitialized;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifScrollBarUI();
    }

    protected void configureScrollBarColors() {
        if (!scrollBarColorsInitialized) {
            thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
            thumbShadowColor = UIManager.getColor("ScrollBar.thumbLightShadow");
            thumbColor = UIManager.getColor("ScrollBar.thumb");
            trackColor = UIManager.getColor("ScrollBar.track");
            scrollBarColorsInitialized = true;
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(n + 11, n2 + 33);
        }
        return new Dimension(n + 33, n2 + 11);
    }

    protected Dimension getMinimumThumbSize() {
        return minimumThumbSize;
    }

    protected Dimension getMaximumThumbSize() {
        return maximumThumbSize;
    }

    protected JButton createDecreaseButton(int n) {
        return new MotifScrollBarButton(n);
    }

    protected JButton createIncreaseButton(int n) {
        return new MotifScrollBarButton(n);
    }

    public void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(trackColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(thumbColor);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(thumbHighlightColor);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.drawLine(1, 0, n - 1, 0);
        graphics.setColor(thumbShadowColor);
        graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }
}

