/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JSlider;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicSliderUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class MotifSliderUI
extends BasicSliderUI {
    static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(164, 15);
    static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(15, 164);
    static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(43, 15);
    static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(15, 43);

    public MotifSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifSliderUI((JSlider)jComponent);
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    public void calculateThumbBounds() {
        if (this.slider.getOrientation() == 1) {
            this.setThumbBounds(this.getScrollTrackRect().x, this.yPositionForValue(this.slider.getValue()) - this.getThumbRect().height / 2, this.getScrollTrackRect().width, 30);
            return;
        }
        this.setThumbBounds(this.xPositionForValue(this.slider.getValue()) - this.getThumbRect().width / 2, this.getScrollTrackRect().y, 30, this.getScrollTrackRect().height);
    }

    public void paintFocus(Graphics graphics) {
    }

    public void paintTrack(Graphics graphics) {
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.getThumbRect();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getForeground());
        } else {
            graphics.setColor(this.slider.getForeground().darker());
        }
        if (this.slider.getOrientation() == 0) {
            graphics.translate(0, rectangle.y - 1);
            graphics.fillRect(n, 1, n3, n4 - 1);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(n, 1, n + n3 - 1, 1);
            graphics.drawLine(n, 1, n, n4);
            graphics.drawLine(n + n3 / 2, 2, n + n3 / 2, n4 - 1);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(n + 1, n4, n + n3 - 1, n4);
            graphics.drawLine(n + n3 - 1, 1, n + n3 - 1, n4);
            graphics.drawLine(n + n3 / 2 - 1, 2, n + n3 / 2 - 1, n4);
            graphics.translate(0, -(rectangle.y - 1));
            return;
        }
        graphics.translate(rectangle.x - 1, 0);
        graphics.fillRect(1, n2, n3 - 1, n4);
        graphics.setColor(this.getHighlightColor());
        graphics.drawLine(1, n2, n3, n2);
        graphics.drawLine(1, n2 + 1, 1, n2 + n4 - 1);
        graphics.drawLine(2, n2 + n4 / 2, n3 - 1, n2 + n4 / 2);
        graphics.setColor(this.getShadowColor());
        graphics.drawLine(2, n2 + n4 - 1, n3, n2 + n4 - 1);
        graphics.drawLine(n3, n2 + n4 - 1, n3, n2);
        graphics.drawLine(2, n2 + n4 / 2 - 1, n3 - 1, n2 + n4 / 2 - 1);
        graphics.translate(-(rectangle.x - 1), 0);
    }
}

