;               System printer configuration file
;
;	    	Use on Windows to print to system printer
;

;
;   You may produce non-halftoned monochrome output on a color
;   device by setting "num_pens=1".
;
;   When thin vector elements with highly saturated colors are half-toned,
;   they can be extraordinarily difficult to see.  You may wish to
;   assign such element colors to a specific pen.  That pen can in turn
;   be assigned an RGB value of your choice.
;
;   For example, to change element color 5 from a hard to see, highly
;   saturated white to an easier to see gray you could use the following
;   line:
;	    pen(6)=(5)/rgb=(230, 230, 230)  ; gray
;
num_pens   = 255                            ; required record
model      = sysprinter

stroke_tolerance=10                         ; unitless num 0 < tol < 10

rotate=none
autocenter

;
;  If you are using Windows 95/3.x you will want to change 'hardware' to 
;  'nohardware' in the linestyle definitions below. Otherwise it will result
;  in the inability to plot lines that have both weight and style.  This is
;  due to a limitation in the Graphics Device Interface of Windows 95/3.x.
;  Note that making this change can result in less-compact printer output
;  from MicroStation.
;
style(1)=(8, 18)/nohardware               ;style = dot
style(2)=(50, 17)/nohardware               ;style = med dash
style(3)=(100, 25)/nohardware              ;style = long dash
style(4)=(45, 12, 8, 12)/nohardware        ;style = dot-dash
style(5)=(17, 17)/nohardware               ;style = short dash
style(6)=(35, 8, 8, 8, 8, 8)/nohardware    ;style = dash-dot-dot
style(7)=(33, 8, 17, 8)/nohardware         ;style = long dash - short dash

;
; linecap, linejoin and miter_limit
; Note: these settings do not have an effect in Win95/3.x 
;       due to a limitation in the Graphics Device Interface
;
linecap	    = 1			; 1=butt, 2=square, 4=round
linejoin    = 5			; 2=miter/bevel, 4=round, 5=beveled
miter_limit = 1.415     ; Larger values allow longer spikes w/linejoin=2

; Specify the mapping of MicroStation line weights to line thickness on paper.
; Units are MM, IN, or DOTS (the default)
weight_strokes(mm)=(0.10, 0.20, 0.50, 1.00, 1.25, 1.50, 1.75, 2.00, \
		    2.25, 2.50, 2.75, 3.00, 3.25, 3.50, 3.75, 4.00, \
		    4.25, 4.50, 4.75, 5.00, 5.25, 5.50, 5.75, 6.00, \
		    6.25, 6.50, 6.75, 7.00, 7.25, 7.50, 7.75, 8.00)


; Remove this if no border is desired
; available qualifiers 
;       /pen=n		    specifies pen to use to draw border
;       /time		    adds time and date to border
;       /filename	    adds name of design file to border
;       /text_height=n      units are cm
;       /width=n	    units are cm
;       /font="fontname"    e.g. "Arial"    
;			    font names can be found by looking at 
;			    StartMenu => Settings => ControlPanel => Fonts.
;			    Note: a truetype font, like Arial, will scale 
;			    better than a bitmap font like MS Sans Serif
;border /pen=1 /time /filename /text_height=0.4							    

; Remove this if no fence outline is desired
;fence_outline/pen=1

; specifies Resolution on Mac and Units on Mac and OS/2
resolution(IN)=(0.0,0.0)

; The record, hardware_raster, can be used to plot raster element
; types 87 and 88 and raster reference elements.  Values for resolution can
; be as high as your plotter's resolution.  Lower values produce grainer images.
; If this line is omitted, or the resolution specified is not a legal value,
; a value of 1/2 of the plotter's resolution will be used. 
;
; Note: Most color devices must perform dithering to generate all the required
; colors when there are only 3 or 4 inks available. So setting raster resolution, 
; to a value greater than 1/2 (or even 1/4) of the plotter's resolution, may 
; not improve image quality and may increase the time required for plotting.
; hardware_raster /resolution=150

; Substitute the name of a pentable file to be loaded when this driver is selected
;pentable=\dir\file.tbl



; *** For Windows Platform Only ***
; Uncomment this line to designate a specific system printer, form, orientation,
; and offset.  These options can be used alone or in combination.
;
; format is:
;		sysprinter  /name="printer-name" 
;			    /form=f
;			    /orientation=o
;			    /offset=(h,v)
;
;   /name
;	    Notes on specifying the printer name: To obtain a valid printer name, first open
;	    the StartMenu => Settings => Printers folder. Next to the icon for each printer is
;	    the printer name. The name will take one of two forms: 1) A local printer name
;	    like "HP LaserJet 4 Plus", or 2) a network printer name like "hp755cm on printserver"
;	    which specifies a network computer and a printer share name.
;
;	    For case 1, the printer name used, in the sysprinter line below, is just the local
;	    name exactly as seen in the Printers folder. e.g. /name="HP LaserJet 4 Plus".
;
;	    For case 2, the printer name used, in the sysprinter line below, is specified as
;	    \\computer\share. e.g. /name="\\printserver\hp755cm"
;
;	    If the printer is shared on the network by the machine MicroStation is running on,
;	    then the printer name shown (in the Printers folder) will be a type 1 (local) name.
;	    In this case, you may specify either format. The computer name needed for the type 2
;	    format can be found by looking at StartMenu => Settings => ControlPanel => Network.
;
;	    If the printer name contains spaces, it should be enclosed in "".
;	    e.g. /name="HP LaserJet 4 Plus".
;	    The /name qualifier is optional.  If omitted, the Windows default printer will be used. 
;
;   /form
;       This value can be any valid form name for that printer, e.g. letter, legal, etc.
;       The list of all valid form names is contained in MicroStation documentation.
;       The list of form names, which will be valid for a particular printer, will be subset 
;       of this list. The /form qualifier is optional.  If omitted, the Windows default 
;       setting for the named printer will be used. 
;
;   /orientation
;       This value is either portrait or landscape.  The /orientation qualifier is optional.
;       If omitted, the Windows default setting for the named printer will be used. 
;
;   /offset 
;       leave horzontal and vertical space for the border text - a setting of (0.00, 0.25) 
;       will leave a 1/4 inch space at the bottom of the plot so border text may be drawn; 
;       Units are inches if your measurement systems is set to US. Units are MM if your 
;       measurement systems is set to Metric. Measurement setting can be found by looking at 
;       StartMenu => Settings => ControlPanel => Regional Settings.
;       The /offset qualifier is optional.  If omitted, no space will be left.
sysprinter /offset=(0.00, 0.25)



; This keyword controls the size (diameter) of points. Units are cm. 
; A value of 0, disables point drawing.
; Note that with some system printer drivers, setting this value 
; too small, may result in no point being drawn.
point_size = 0.001


;
; The following options allow raster plotting of images.
;
MDLCOMMAND          =implot
ISV_RASTER = 1 ; Plots the raster image,  1=On 0=Off  Default=1
PIXEL_RESOLUTION = 80 ; Resolution of pixels on output (dpi) Default=80
CONTRAST 	    = 50	    ; Contrast in percent, between 0-100   Default=50
BRIGHTNESS 	    = 50	    ; Brightness in percent, between 0-100 Default=50
RASTER_FENCE 	    = 0		    ; Clip the raster to fence, 1=On 0=Off Default=0
GRAYSCALE = 1 ; Plot in gray scale,  1=On 0=Off 	   Default=0
NO_DGNRASTER 	    = 1             ; MS plot of 87/88, 1=Don't plot 0=Plot Default=1
NO_RASTERREF 	    = 0		    ; MS plot of 90's,  1=Don't plot 0=Plot Default=0
